<?php

namespace EnumType;

/**
 * This class stands for SuitabilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Identification of specific SUITABILITY.
 * @subpackage Enumerations
 */
class SuitabilityEnumeration
{
    /**
     * Constant for value 'suitable'
     * @return string 'suitable'
     */
    const VALUE_SUITABLE = 'suitable';
    /**
     * Constant for value 'notSuitable'
     * @return string 'notSuitable'
     */
    const VALUE_NOT_SUITABLE = 'notSuitable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUITABLE
     * @uses self::VALUE_NOT_SUITABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUITABLE,
            self::VALUE_NOT_SUITABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
