<?php

namespace EnumType;

/**
 * This class stands for StatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Indicates whether the entity this annotates is available for use. Use of this attribute allows entities to be retired without deleting the details from the dataset.
 * @subpackage Enumerations
 */
class StatusEnumeration
{
    /**
     * Constant for value 'active'
     * @return string 'active'
     */
    const VALUE_ACTIVE = 'active';
    /**
     * Constant for value 'inactive'
     * @return string 'inactive'
     */
    const VALUE_INACTIVE = 'inactive';
    /**
     * Constant for value 'pending'
     * @return string 'pending'
     */
    const VALUE_PENDING = 'pending';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_INACTIVE
     * @uses self::VALUE_PENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_INACTIVE,
            self::VALUE_PENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
