<?php

namespace EnumType;

/**
 * This class stands for SpeedManagementTypeEnum EnumType
 * @subpackage Enumerations
 */
class SpeedManagementTypeEnum
{
    /**
     * Constant for value 'activeSpeedControlInOperation'
     * @return string 'activeSpeedControlInOperation'
     */
    const VALUE_ACTIVE_SPEED_CONTROL_IN_OPERATION = 'activeSpeedControlInOperation';
    /**
     * Constant for value 'doNotSlowdownUnnecessarily'
     * @return string 'doNotSlowdownUnnecessarily'
     */
    const VALUE_DO_NOT_SLOWDOWN_UNNECESSARILY = 'doNotSlowdownUnnecessarily';
    /**
     * Constant for value 'observeSpeedLimit'
     * @return string 'observeSpeedLimit'
     */
    const VALUE_OBSERVE_SPEED_LIMIT = 'observeSpeedLimit';
    /**
     * Constant for value 'policeSpeedChecksInOperation'
     * @return string 'policeSpeedChecksInOperation'
     */
    const VALUE_POLICE_SPEED_CHECKS_IN_OPERATION = 'policeSpeedChecksInOperation';
    /**
     * Constant for value 'reduceYourSpeed'
     * @return string 'reduceYourSpeed'
     */
    const VALUE_REDUCE_YOUR_SPEED = 'reduceYourSpeed';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE_SPEED_CONTROL_IN_OPERATION
     * @uses self::VALUE_DO_NOT_SLOWDOWN_UNNECESSARILY
     * @uses self::VALUE_OBSERVE_SPEED_LIMIT
     * @uses self::VALUE_POLICE_SPEED_CHECKS_IN_OPERATION
     * @uses self::VALUE_REDUCE_YOUR_SPEED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE_SPEED_CONTROL_IN_OPERATION,
            self::VALUE_DO_NOT_SLOWDOWN_UNNECESSARILY,
            self::VALUE_OBSERVE_SPEED_LIMIT,
            self::VALUE_POLICE_SPEED_CHECKS_IN_OPERATION,
            self::VALUE_REDUCE_YOUR_SPEED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
