<?php

namespace EnumType;

/**
 * This class stands for SourceTypeEnum EnumType
 * @subpackage Enumerations
 */
class SourceTypeEnum
{
    /**
     * Constant for value 'automobileClubPatrol'
     * @return string 'automobileClubPatrol'
     */
    const VALUE_AUTOMOBILE_CLUB_PATROL = 'automobileClubPatrol';
    /**
     * Constant for value 'cameraObservation'
     * @return string 'cameraObservation'
     */
    const VALUE_CAMERA_OBSERVATION = 'cameraObservation';
    /**
     * Constant for value 'freightVehicleOperator'
     * @return string 'freightVehicleOperator'
     */
    const VALUE_FREIGHT_VEHICLE_OPERATOR = 'freightVehicleOperator';
    /**
     * Constant for value 'inductionLoopMonitoringStation'
     * @return string 'inductionLoopMonitoringStation'
     */
    const VALUE_INDUCTION_LOOP_MONITORING_STATION = 'inductionLoopMonitoringStation';
    /**
     * Constant for value 'infraredMonitoringStation'
     * @return string 'infraredMonitoringStation'
     */
    const VALUE_INFRARED_MONITORING_STATION = 'infraredMonitoringStation';
    /**
     * Constant for value 'microwaveMonitoringStation'
     * @return string 'microwaveMonitoringStation'
     */
    const VALUE_MICROWAVE_MONITORING_STATION = 'microwaveMonitoringStation';
    /**
     * Constant for value 'mobileTelephoneCaller'
     * @return string 'mobileTelephoneCaller'
     */
    const VALUE_MOBILE_TELEPHONE_CALLER = 'mobileTelephoneCaller';
    /**
     * Constant for value 'nonPoliceEmergencyServicePatrol'
     * @return string 'nonPoliceEmergencyServicePatrol'
     */
    const VALUE_NON_POLICE_EMERGENCY_SERVICE_PATROL = 'nonPoliceEmergencyServicePatrol';
    /**
     * Constant for value 'otherInformation'
     * @return string 'otherInformation'
     */
    const VALUE_OTHER_INFORMATION = 'otherInformation';
    /**
     * Constant for value 'otherOfficialVehicle'
     * @return string 'otherOfficialVehicle'
     */
    const VALUE_OTHER_OFFICIAL_VEHICLE = 'otherOfficialVehicle';
    /**
     * Constant for value 'policePatrol'
     * @return string 'policePatrol'
     */
    const VALUE_POLICE_PATROL = 'policePatrol';
    /**
     * Constant for value 'privateBreakdownService'
     * @return string 'privateBreakdownService'
     */
    const VALUE_PRIVATE_BREAKDOWN_SERVICE = 'privateBreakdownService';
    /**
     * Constant for value 'publicAndPrivateUtilities'
     * @return string 'publicAndPrivateUtilities'
     */
    const VALUE_PUBLIC_AND_PRIVATE_UTILITIES = 'publicAndPrivateUtilities';
    /**
     * Constant for value 'registeredMotoristObserver'
     * @return string 'registeredMotoristObserver'
     */
    const VALUE_REGISTERED_MOTORIST_OBSERVER = 'registeredMotoristObserver';
    /**
     * Constant for value 'roadAuthorities'
     * @return string 'roadAuthorities'
     */
    const VALUE_ROAD_AUTHORITIES = 'roadAuthorities';
    /**
     * Constant for value 'roadOperatorPatrol'
     * @return string 'roadOperatorPatrol'
     */
    const VALUE_ROAD_OPERATOR_PATROL = 'roadOperatorPatrol';
    /**
     * Constant for value 'roadsideTelephoneCaller'
     * @return string 'roadsideTelephoneCaller'
     */
    const VALUE_ROADSIDE_TELEPHONE_CALLER = 'roadsideTelephoneCaller';
    /**
     * Constant for value 'spotterAircraft'
     * @return string 'spotterAircraft'
     */
    const VALUE_SPOTTER_AIRCRAFT = 'spotterAircraft';
    /**
     * Constant for value 'trafficMonitoringStation'
     * @return string 'trafficMonitoringStation'
     */
    const VALUE_TRAFFIC_MONITORING_STATION = 'trafficMonitoringStation';
    /**
     * Constant for value 'transitOperator'
     * @return string 'transitOperator'
     */
    const VALUE_TRANSIT_OPERATOR = 'transitOperator';
    /**
     * Constant for value 'vehicleProbeMeasurement'
     * @return string 'vehicleProbeMeasurement'
     */
    const VALUE_VEHICLE_PROBE_MEASUREMENT = 'vehicleProbeMeasurement';
    /**
     * Constant for value 'videoProcessingMonitoringStation'
     * @return string 'videoProcessingMonitoringStation'
     */
    const VALUE_VIDEO_PROCESSING_MONITORING_STATION = 'videoProcessingMonitoringStation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTOMOBILE_CLUB_PATROL
     * @uses self::VALUE_CAMERA_OBSERVATION
     * @uses self::VALUE_FREIGHT_VEHICLE_OPERATOR
     * @uses self::VALUE_INDUCTION_LOOP_MONITORING_STATION
     * @uses self::VALUE_INFRARED_MONITORING_STATION
     * @uses self::VALUE_MICROWAVE_MONITORING_STATION
     * @uses self::VALUE_MOBILE_TELEPHONE_CALLER
     * @uses self::VALUE_NON_POLICE_EMERGENCY_SERVICE_PATROL
     * @uses self::VALUE_OTHER_INFORMATION
     * @uses self::VALUE_OTHER_OFFICIAL_VEHICLE
     * @uses self::VALUE_POLICE_PATROL
     * @uses self::VALUE_PRIVATE_BREAKDOWN_SERVICE
     * @uses self::VALUE_PUBLIC_AND_PRIVATE_UTILITIES
     * @uses self::VALUE_REGISTERED_MOTORIST_OBSERVER
     * @uses self::VALUE_ROAD_AUTHORITIES
     * @uses self::VALUE_ROAD_OPERATOR_PATROL
     * @uses self::VALUE_ROADSIDE_TELEPHONE_CALLER
     * @uses self::VALUE_SPOTTER_AIRCRAFT
     * @uses self::VALUE_TRAFFIC_MONITORING_STATION
     * @uses self::VALUE_TRANSIT_OPERATOR
     * @uses self::VALUE_VEHICLE_PROBE_MEASUREMENT
     * @uses self::VALUE_VIDEO_PROCESSING_MONITORING_STATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTOMOBILE_CLUB_PATROL,
            self::VALUE_CAMERA_OBSERVATION,
            self::VALUE_FREIGHT_VEHICLE_OPERATOR,
            self::VALUE_INDUCTION_LOOP_MONITORING_STATION,
            self::VALUE_INFRARED_MONITORING_STATION,
            self::VALUE_MICROWAVE_MONITORING_STATION,
            self::VALUE_MOBILE_TELEPHONE_CALLER,
            self::VALUE_NON_POLICE_EMERGENCY_SERVICE_PATROL,
            self::VALUE_OTHER_INFORMATION,
            self::VALUE_OTHER_OFFICIAL_VEHICLE,
            self::VALUE_POLICE_PATROL,
            self::VALUE_PRIVATE_BREAKDOWN_SERVICE,
            self::VALUE_PUBLIC_AND_PRIVATE_UTILITIES,
            self::VALUE_REGISTERED_MOTORIST_OBSERVER,
            self::VALUE_ROAD_AUTHORITIES,
            self::VALUE_ROAD_OPERATOR_PATROL,
            self::VALUE_ROADSIDE_TELEPHONE_CALLER,
            self::VALUE_SPOTTER_AIRCRAFT,
            self::VALUE_TRAFFIC_MONITORING_STATION,
            self::VALUE_TRANSIT_OPERATOR,
            self::VALUE_VEHICLE_PROBE_MEASUREMENT,
            self::VALUE_VIDEO_PROCESSING_MONITORING_STATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
