<?php

namespace EnumType;

/**
 * This class stands for SituationSourceTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Type of Source.
 * @subpackage Enumerations
 */
class SituationSourceTypeEnumeration
{
    /**
     * Constant for value 'directReport'
     * @return string 'directReport'
     */
    const VALUE_DIRECT_REPORT = 'directReport';
    /**
     * Constant for value 'email'
     * @return string 'email'
     */
    const VALUE_EMAIL = 'email';
    /**
     * Constant for value 'phone'
     * @return string 'phone'
     */
    const VALUE_PHONE = 'phone';
    /**
     * Constant for value 'fax'
     * @return string 'fax'
     */
    const VALUE_FAX = 'fax';
    /**
     * Constant for value 'post'
     * @return string 'post'
     */
    const VALUE_POST = 'post';
    /**
     * Constant for value 'feed'
     * @return string 'feed'
     */
    const VALUE_FEED = 'feed';
    /**
     * Constant for value 'radio'
     * @return string 'radio'
     */
    const VALUE_RADIO = 'radio';
    /**
     * Constant for value 'tv'
     * @return string 'tv'
     */
    const VALUE_TV = 'tv';
    /**
     * Constant for value 'web'
     * @return string 'web'
     */
    const VALUE_WEB = 'web';
    /**
     * Constant for value 'pager'
     * @return string 'pager'
     */
    const VALUE_PAGER = 'pager';
    /**
     * Constant for value 'text'
     * @return string 'text'
     */
    const VALUE_TEXT = 'text';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIRECT_REPORT
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_FAX
     * @uses self::VALUE_POST
     * @uses self::VALUE_FEED
     * @uses self::VALUE_RADIO
     * @uses self::VALUE_TV
     * @uses self::VALUE_WEB
     * @uses self::VALUE_PAGER
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIRECT_REPORT,
            self::VALUE_EMAIL,
            self::VALUE_PHONE,
            self::VALUE_FAX,
            self::VALUE_POST,
            self::VALUE_FEED,
            self::VALUE_RADIO,
            self::VALUE_TV,
            self::VALUE_WEB,
            self::VALUE_PAGER,
            self::VALUE_TEXT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
