<?php

namespace EnumType;

/**
 * This class stands for SeverityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Severity. Correspond to TPEG Pti26 Severity values.
 * @subpackage Enumerations
 */
class SeverityEnumeration
{
    /**
     * Constant for value 'pti26_0'
     * @return string 'pti26_0'
     */
    const VALUE_PTI_26_0 = 'pti26_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti26_1'
     * @return string 'pti26_1'
     */
    const VALUE_PTI_26_1 = 'pti26_1';
    /**
     * Constant for value 'verySlight'
     * @return string 'verySlight'
     */
    const VALUE_VERY_SLIGHT = 'verySlight';
    /**
     * Constant for value 'pti26_2'
     * @return string 'pti26_2'
     */
    const VALUE_PTI_26_2 = 'pti26_2';
    /**
     * Constant for value 'slight'
     * @return string 'slight'
     */
    const VALUE_SLIGHT = 'slight';
    /**
     * Constant for value 'pti26_3'
     * @return string 'pti26_3'
     */
    const VALUE_PTI_26_3 = 'pti26_3';
    /**
     * Constant for value 'normal'
     * @return string 'normal'
     */
    const VALUE_NORMAL = 'normal';
    /**
     * Constant for value 'pti26_4'
     * @return string 'pti26_4'
     */
    const VALUE_PTI_26_4 = 'pti26_4';
    /**
     * Constant for value 'severe'
     * @return string 'severe'
     */
    const VALUE_SEVERE = 'severe';
    /**
     * Constant for value 'pti26_5'
     * @return string 'pti26_5'
     */
    const VALUE_PTI_26_5 = 'pti26_5';
    /**
     * Constant for value 'verySevere'
     * @return string 'verySevere'
     */
    const VALUE_VERY_SEVERE = 'verySevere';
    /**
     * Constant for value 'pti26_6'
     * @return string 'pti26_6'
     */
    const VALUE_PTI_26_6 = 'pti26_6';
    /**
     * Constant for value 'noImpact'
     * @return string 'noImpact'
     */
    const VALUE_NO_IMPACT = 'noImpact';
    /**
     * Constant for value 'pti26_255'
     * @return string 'pti26_255'
     */
    const VALUE_PTI_26_255 = 'pti26_255';
    /**
     * Constant for value 'undefined'
     * @return string 'undefined'
     */
    const VALUE_UNDEFINED = 'undefined';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_26_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_26_1
     * @uses self::VALUE_VERY_SLIGHT
     * @uses self::VALUE_PTI_26_2
     * @uses self::VALUE_SLIGHT
     * @uses self::VALUE_PTI_26_3
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PTI_26_4
     * @uses self::VALUE_SEVERE
     * @uses self::VALUE_PTI_26_5
     * @uses self::VALUE_VERY_SEVERE
     * @uses self::VALUE_PTI_26_6
     * @uses self::VALUE_NO_IMPACT
     * @uses self::VALUE_PTI_26_255
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_26_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_26_1,
            self::VALUE_VERY_SLIGHT,
            self::VALUE_PTI_26_2,
            self::VALUE_SLIGHT,
            self::VALUE_PTI_26_3,
            self::VALUE_NORMAL,
            self::VALUE_PTI_26_4,
            self::VALUE_SEVERE,
            self::VALUE_PTI_26_5,
            self::VALUE_VERY_SEVERE,
            self::VALUE_PTI_26_6,
            self::VALUE_NO_IMPACT,
            self::VALUE_PTI_26_255,
            self::VALUE_UNDEFINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
