<?php

namespace EnumType;

/**
 * This class stands for ServiceExceptionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of the service exception
 * @subpackage Enumerations
 */
class ServiceExceptionEnumeration
{
    /**
     * Constant for value 'beforeFirstJourney'
     * @return string 'beforeFirstJourney'
     */
    const VALUE_BEFORE_FIRST_JOURNEY = 'beforeFirstJourney';
    /**
     * Constant for value 'afterLastJourney'
     * @return string 'afterLastJourney'
     */
    const VALUE_AFTER_LAST_JOURNEY = 'afterLastJourney';
    /**
     * Constant for value 'noServiceToday'
     * @return string 'noServiceToday'
     */
    const VALUE_NO_SERVICE_TODAY = 'noServiceToday';
    /**
     * Constant for value 'transportTemporarilySuspended'
     * @return string 'transportTemporarilySuspended'
     */
    const VALUE_TRANSPORT_TEMPORARILY_SUSPENDED = 'transportTemporarilySuspended';
    /**
     * Constant for value 'transportLongtermSuspended'
     * @return string 'transportLongtermSuspended'
     */
    const VALUE_TRANSPORT_LONGTERM_SUSPENDED = 'transportLongtermSuspended';
    /**
     * Constant for value 'transportSeverlyDisrupted'
     * @return string 'transportSeverlyDisrupted'
     */
    const VALUE_TRANSPORT_SEVERLY_DISRUPTED = 'transportSeverlyDisrupted';
    /**
     * Constant for value 'realtimeDataNotAvailable'
     * @return string 'realtimeDataNotAvailable'
     */
    const VALUE_REALTIME_DATA_NOT_AVAILABLE = 'realtimeDataNotAvailable';
    /**
     * Constant for value 'realtimeDataAvailable'
     * @return string 'realtimeDataAvailable'
     */
    const VALUE_REALTIME_DATA_AVAILABLE = 'realtimeDataAvailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEFORE_FIRST_JOURNEY
     * @uses self::VALUE_AFTER_LAST_JOURNEY
     * @uses self::VALUE_NO_SERVICE_TODAY
     * @uses self::VALUE_TRANSPORT_TEMPORARILY_SUSPENDED
     * @uses self::VALUE_TRANSPORT_LONGTERM_SUSPENDED
     * @uses self::VALUE_TRANSPORT_SEVERLY_DISRUPTED
     * @uses self::VALUE_REALTIME_DATA_NOT_AVAILABLE
     * @uses self::VALUE_REALTIME_DATA_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEFORE_FIRST_JOURNEY,
            self::VALUE_AFTER_LAST_JOURNEY,
            self::VALUE_NO_SERVICE_TODAY,
            self::VALUE_TRANSPORT_TEMPORARILY_SUSPENDED,
            self::VALUE_TRANSPORT_LONGTERM_SUSPENDED,
            self::VALUE_TRANSPORT_SEVERLY_DISRUPTED,
            self::VALUE_REALTIME_DATA_NOT_AVAILABLE,
            self::VALUE_REALTIME_DATA_AVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
