<?php

namespace EnumType;

/**
 * This class stands for ServiceConditionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Service Condition. Corresponds to TPEG Pti13 Service Condition values.
 * @subpackage Enumerations
 */
class ServiceConditionEnumeration
{
    /**
     * Constant for value 'pti13_0'
     * @return string 'pti13_0'
     */
    const VALUE_PTI_13_0 = 'pti13_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti13_1'
     * @return string 'pti13_1'
     */
    const VALUE_PTI_13_1 = 'pti13_1';
    /**
     * Constant for value 'altered'
     * @return string 'altered'
     */
    const VALUE_ALTERED = 'altered';
    /**
     * Constant for value 'pti13_2'
     * @return string 'pti13_2'
     */
    const VALUE_PTI_13_2 = 'pti13_2';
    /**
     * Constant for value 'cancelled'
     * @return string 'cancelled'
     */
    const VALUE_CANCELLED = 'cancelled';
    /**
     * Constant for value 'pti13_3'
     * @return string 'pti13_3'
     */
    const VALUE_PTI_13_3 = 'pti13_3';
    /**
     * Constant for value 'delayed'
     * @return string 'delayed'
     */
    const VALUE_DELAYED = 'delayed';
    /**
     * Constant for value 'pti13_4'
     * @return string 'pti13_4'
     */
    const VALUE_PTI_13_4 = 'pti13_4';
    /**
     * Constant for value 'diverted'
     * @return string 'diverted'
     */
    const VALUE_DIVERTED = 'diverted';
    /**
     * Constant for value 'pti13_5'
     * @return string 'pti13_5'
     */
    const VALUE_PTI_13_5 = 'pti13_5';
    /**
     * Constant for value 'noService'
     * @return string 'noService'
     */
    const VALUE_NO_SERVICE = 'noService';
    /**
     * Constant for value 'pti13_6'
     * @return string 'pti13_6'
     */
    const VALUE_PTI_13_6 = 'pti13_6';
    /**
     * Constant for value 'disrupted'
     * @return string 'disrupted'
     */
    const VALUE_DISRUPTED = 'disrupted';
    /**
     * Constant for value 'pti13_7'
     * @return string 'pti13_7'
     */
    const VALUE_PTI_13_7 = 'pti13_7';
    /**
     * Constant for value 'additionalService'
     * @return string 'additionalService'
     */
    const VALUE_ADDITIONAL_SERVICE = 'additionalService';
    /**
     * Constant for value 'pti13_8'
     * @return string 'pti13_8'
     */
    const VALUE_PTI_13_8 = 'pti13_8';
    /**
     * Constant for value 'specialService'
     * @return string 'specialService'
     */
    const VALUE_SPECIAL_SERVICE = 'specialService';
    /**
     * Constant for value 'pti13_9'
     * @return string 'pti13_9'
     */
    const VALUE_PTI_13_9 = 'pti13_9';
    /**
     * Constant for value 'onTime'
     * @return string 'onTime'
     */
    const VALUE_ON_TIME = 'onTime';
    /**
     * Constant for value 'pti13_10'
     * @return string 'pti13_10'
     */
    const VALUE_PTI_13_10 = 'pti13_10';
    /**
     * Constant for value 'normalService'
     * @return string 'normalService'
     */
    const VALUE_NORMAL_SERVICE = 'normalService';
    /**
     * Constant for value 'pti13_11'
     * @return string 'pti13_11'
     */
    const VALUE_PTI_13_11 = 'pti13_11';
    /**
     * Constant for value 'intermittentService'
     * @return string 'intermittentService'
     */
    const VALUE_INTERMITTENT_SERVICE = 'intermittentService';
    /**
     * Constant for value 'pti13_12'
     * @return string 'pti13_12'
     */
    const VALUE_PTI_13_12 = 'pti13_12';
    /**
     * Constant for value 'shortFormedService'
     * @return string 'shortFormedService'
     */
    const VALUE_SHORT_FORMED_SERVICE = 'shortFormedService';
    /**
     * Constant for value 'pti13_13'
     * @return string 'pti13_13'
     */
    const VALUE_PTI_13_13 = 'pti13_13';
    /**
     * Constant for value 'fullLengthService'
     * @return string 'fullLengthService'
     */
    const VALUE_FULL_LENGTH_SERVICE = 'fullLengthService';
    /**
     * Constant for value 'pti13_14'
     * @return string 'pti13_14'
     */
    const VALUE_PTI_13_14 = 'pti13_14';
    /**
     * Constant for value 'extendedService'
     * @return string 'extendedService'
     */
    const VALUE_EXTENDED_SERVICE = 'extendedService';
    /**
     * Constant for value 'pti13_15'
     * @return string 'pti13_15'
     */
    const VALUE_PTI_13_15 = 'pti13_15';
    /**
     * Constant for value 'splittingTrain'
     * @return string 'splittingTrain'
     */
    const VALUE_SPLITTING_TRAIN = 'splittingTrain';
    /**
     * Constant for value 'pti13_16'
     * @return string 'pti13_16'
     */
    const VALUE_PTI_13_16 = 'pti13_16';
    /**
     * Constant for value 'replacementTransport'
     * @return string 'replacementTransport'
     */
    const VALUE_REPLACEMENT_TRANSPORT = 'replacementTransport';
    /**
     * Constant for value 'pti13_17'
     * @return string 'pti13_17'
     */
    const VALUE_PTI_13_17 = 'pti13_17';
    /**
     * Constant for value 'arrivesEarly'
     * @return string 'arrivesEarly'
     */
    const VALUE_ARRIVES_EARLY = 'arrivesEarly';
    /**
     * Constant for value 'pti13_18'
     * @return string 'pti13_18'
     */
    const VALUE_PTI_13_18 = 'pti13_18';
    /**
     * Constant for value 'shuttleService'
     * @return string 'shuttleService'
     */
    const VALUE_SHUTTLE_SERVICE = 'shuttleService';
    /**
     * Constant for value 'pti13_19'
     * @return string 'pti13_19'
     */
    const VALUE_PTI_13_19 = 'pti13_19';
    /**
     * Constant for value 'replacementService'
     * @return string 'replacementService'
     */
    const VALUE_REPLACEMENT_SERVICE = 'replacementService';
    /**
     * Constant for value 'pti13_255'
     * @return string 'pti13_255'
     */
    const VALUE_PTI_13_255 = 'pti13_255';
    /**
     * Constant for value 'undefinedServiceInformation'
     * @return string 'undefinedServiceInformation'
     */
    const VALUE_UNDEFINED_SERVICE_INFORMATION = 'undefinedServiceInformation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_13_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_13_1
     * @uses self::VALUE_ALTERED
     * @uses self::VALUE_PTI_13_2
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PTI_13_3
     * @uses self::VALUE_DELAYED
     * @uses self::VALUE_PTI_13_4
     * @uses self::VALUE_DIVERTED
     * @uses self::VALUE_PTI_13_5
     * @uses self::VALUE_NO_SERVICE
     * @uses self::VALUE_PTI_13_6
     * @uses self::VALUE_DISRUPTED
     * @uses self::VALUE_PTI_13_7
     * @uses self::VALUE_ADDITIONAL_SERVICE
     * @uses self::VALUE_PTI_13_8
     * @uses self::VALUE_SPECIAL_SERVICE
     * @uses self::VALUE_PTI_13_9
     * @uses self::VALUE_ON_TIME
     * @uses self::VALUE_PTI_13_10
     * @uses self::VALUE_NORMAL_SERVICE
     * @uses self::VALUE_PTI_13_11
     * @uses self::VALUE_INTERMITTENT_SERVICE
     * @uses self::VALUE_PTI_13_12
     * @uses self::VALUE_SHORT_FORMED_SERVICE
     * @uses self::VALUE_PTI_13_13
     * @uses self::VALUE_FULL_LENGTH_SERVICE
     * @uses self::VALUE_PTI_13_14
     * @uses self::VALUE_EXTENDED_SERVICE
     * @uses self::VALUE_PTI_13_15
     * @uses self::VALUE_SPLITTING_TRAIN
     * @uses self::VALUE_PTI_13_16
     * @uses self::VALUE_REPLACEMENT_TRANSPORT
     * @uses self::VALUE_PTI_13_17
     * @uses self::VALUE_ARRIVES_EARLY
     * @uses self::VALUE_PTI_13_18
     * @uses self::VALUE_SHUTTLE_SERVICE
     * @uses self::VALUE_PTI_13_19
     * @uses self::VALUE_REPLACEMENT_SERVICE
     * @uses self::VALUE_PTI_13_255
     * @uses self::VALUE_UNDEFINED_SERVICE_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_13_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_13_1,
            self::VALUE_ALTERED,
            self::VALUE_PTI_13_2,
            self::VALUE_CANCELLED,
            self::VALUE_PTI_13_3,
            self::VALUE_DELAYED,
            self::VALUE_PTI_13_4,
            self::VALUE_DIVERTED,
            self::VALUE_PTI_13_5,
            self::VALUE_NO_SERVICE,
            self::VALUE_PTI_13_6,
            self::VALUE_DISRUPTED,
            self::VALUE_PTI_13_7,
            self::VALUE_ADDITIONAL_SERVICE,
            self::VALUE_PTI_13_8,
            self::VALUE_SPECIAL_SERVICE,
            self::VALUE_PTI_13_9,
            self::VALUE_ON_TIME,
            self::VALUE_PTI_13_10,
            self::VALUE_NORMAL_SERVICE,
            self::VALUE_PTI_13_11,
            self::VALUE_INTERMITTENT_SERVICE,
            self::VALUE_PTI_13_12,
            self::VALUE_SHORT_FORMED_SERVICE,
            self::VALUE_PTI_13_13,
            self::VALUE_FULL_LENGTH_SERVICE,
            self::VALUE_PTI_13_14,
            self::VALUE_EXTENDED_SERVICE,
            self::VALUE_PTI_13_15,
            self::VALUE_SPLITTING_TRAIN,
            self::VALUE_PTI_13_16,
            self::VALUE_REPLACEMENT_TRANSPORT,
            self::VALUE_PTI_13_17,
            self::VALUE_ARRIVES_EARLY,
            self::VALUE_PTI_13_18,
            self::VALUE_SHUTTLE_SERVICE,
            self::VALUE_PTI_13_19,
            self::VALUE_REPLACEMENT_SERVICE,
            self::VALUE_PTI_13_255,
            self::VALUE_UNDEFINED_SERVICE_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
