<?php

namespace EnumType;

/**
 * This class stands for SensitivityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Sensitivity.
 * @subpackage Enumerations
 */
class SensitivityEnumeration
{
    /**
     * Constant for value 'veryHigh'
     * @return string 'veryHigh'
     */
    const VALUE_VERY_HIGH = 'veryHigh';
    /**
     * Constant for value 'high'
     * @return string 'high'
     */
    const VALUE_HIGH = 'high';
    /**
     * Constant for value 'medium'
     * @return string 'medium'
     */
    const VALUE_MEDIUM = 'medium';
    /**
     * Constant for value 'low'
     * @return string 'low'
     */
    const VALUE_LOW = 'low';
    /**
     * Constant for value 'veryLow'
     * @return string 'veryLow'
     */
    const VALUE_VERY_LOW = 'veryLow';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VERY_HIGH
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_LOW
     * @uses self::VALUE_VERY_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VERY_HIGH,
            self::VALUE_HIGH,
            self::VALUE_MEDIUM,
            self::VALUE_LOW,
            self::VALUE_VERY_LOW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
