<?php

namespace EnumType;

/**
 * This class stands for ScopeTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for ScopeType.
 * @subpackage Enumerations
 */
class ScopeTypeEnumeration
{
    /**
     * Constant for value 'general'
     * @return string 'general'
     */
    const VALUE_GENERAL = 'general';
    /**
     * Constant for value 'operator'
     * @return string 'operator'
     */
    const VALUE_OPERATOR = 'operator';
    /**
     * Constant for value 'network'
     * @return string 'network'
     */
    const VALUE_NETWORK = 'network';
    /**
     * Constant for value 'route'
     * @return string 'route'
     */
    const VALUE_ROUTE = 'route';
    /**
     * Constant for value 'line'
     * @return string 'line'
     */
    const VALUE_LINE = 'line';
    /**
     * Constant for value 'place'
     * @return string 'place'
     */
    const VALUE_PLACE = 'place';
    /**
     * Constant for value 'stopPlace'
     * @return string 'stopPlace'
     */
    const VALUE_STOP_PLACE = 'stopPlace';
    /**
     * Constant for value 'stopPlaceComponent'
     * @return string 'stopPlaceComponent'
     */
    const VALUE_STOP_PLACE_COMPONENT = 'stopPlaceComponent';
    /**
     * Constant for value 'stopPoint'
     * @return string 'stopPoint'
     */
    const VALUE_STOP_POINT = 'stopPoint';
    /**
     * Constant for value 'vehicleJourney'
     * @return string 'vehicleJourney'
     */
    const VALUE_VEHICLE_JOURNEY = 'vehicleJourney';
    /**
     * Constant for value 'datedVehicleJourney'
     * @return string 'datedVehicleJourney'
     */
    const VALUE_DATED_VEHICLE_JOURNEY = 'datedVehicleJourney';
    /**
     * Constant for value 'connectionLink'
     * @return string 'connectionLink'
     */
    const VALUE_CONNECTION_LINK = 'connectionLink';
    /**
     * Constant for value 'interchange'
     * @return string 'interchange'
     */
    const VALUE_INTERCHANGE = 'interchange';
    /**
     * Constant for value 'allPT'
     * @return string 'allPT'
     */
    const VALUE_ALL_PT = 'allPT';
    /**
     * Constant for value 'road'
     * @return string 'road'
     */
    const VALUE_ROAD = 'road';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_OPERATOR
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_ROUTE
     * @uses self::VALUE_LINE
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_STOP_PLACE
     * @uses self::VALUE_STOP_PLACE_COMPONENT
     * @uses self::VALUE_STOP_POINT
     * @uses self::VALUE_VEHICLE_JOURNEY
     * @uses self::VALUE_DATED_VEHICLE_JOURNEY
     * @uses self::VALUE_CONNECTION_LINK
     * @uses self::VALUE_INTERCHANGE
     * @uses self::VALUE_ALL_PT
     * @uses self::VALUE_ROAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERAL,
            self::VALUE_OPERATOR,
            self::VALUE_NETWORK,
            self::VALUE_ROUTE,
            self::VALUE_LINE,
            self::VALUE_PLACE,
            self::VALUE_STOP_PLACE,
            self::VALUE_STOP_PLACE_COMPONENT,
            self::VALUE_STOP_POINT,
            self::VALUE_VEHICLE_JOURNEY,
            self::VALUE_DATED_VEHICLE_JOURNEY,
            self::VALUE_CONNECTION_LINK,
            self::VALUE_INTERCHANGE,
            self::VALUE_ALL_PT,
            self::VALUE_ROAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
