<?php

namespace EnumType;

/**
 * This class stands for RoadMaintenanceTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoadMaintenanceTypeEnum
{
    /**
     * Constant for value 'clearanceWork'
     * @return string 'clearanceWork'
     */
    const VALUE_CLEARANCE_WORK = 'clearanceWork';
    /**
     * Constant for value 'controlledAvalanche'
     * @return string 'controlledAvalanche'
     */
    const VALUE_CONTROLLED_AVALANCHE = 'controlledAvalanche';
    /**
     * Constant for value 'installationWork'
     * @return string 'installationWork'
     */
    const VALUE_INSTALLATION_WORK = 'installationWork';
    /**
     * Constant for value 'grassCuttingWork'
     * @return string 'grassCuttingWork'
     */
    const VALUE_GRASS_CUTTING_WORK = 'grassCuttingWork';
    /**
     * Constant for value 'maintenanceWork'
     * @return string 'maintenanceWork'
     */
    const VALUE_MAINTENANCE_WORK = 'maintenanceWork';
    /**
     * Constant for value 'overheadWorks'
     * @return string 'overheadWorks'
     */
    const VALUE_OVERHEAD_WORKS = 'overheadWorks';
    /**
     * Constant for value 'repairWork'
     * @return string 'repairWork'
     */
    const VALUE_REPAIR_WORK = 'repairWork';
    /**
     * Constant for value 'resurfacingWork'
     * @return string 'resurfacingWork'
     */
    const VALUE_RESURFACING_WORK = 'resurfacingWork';
    /**
     * Constant for value 'roadMarkingWork'
     * @return string 'roadMarkingWork'
     */
    const VALUE_ROAD_MARKING_WORK = 'roadMarkingWork';
    /**
     * Constant for value 'roadsideWork'
     * @return string 'roadsideWork'
     */
    const VALUE_ROADSIDE_WORK = 'roadsideWork';
    /**
     * Constant for value 'roadworksClearance'
     * @return string 'roadworksClearance'
     */
    const VALUE_ROADWORKS_CLEARANCE = 'roadworksClearance';
    /**
     * Constant for value 'roadworks'
     * @return string 'roadworks'
     */
    const VALUE_ROADWORKS = 'roadworks';
    /**
     * Constant for value 'rockFallPreventativeMaintenance'
     * @return string 'rockFallPreventativeMaintenance'
     */
    const VALUE_ROCK_FALL_PREVENTATIVE_MAINTENANCE = 'rockFallPreventativeMaintenance';
    /**
     * Constant for value 'saltingInProgress'
     * @return string 'saltingInProgress'
     */
    const VALUE_SALTING_IN_PROGRESS = 'saltingInProgress';
    /**
     * Constant for value 'snowploughsInUse'
     * @return string 'snowploughsInUse'
     */
    const VALUE_SNOWPLOUGHS_IN_USE = 'snowploughsInUse';
    /**
     * Constant for value 'treeAndVegetationCuttingWork'
     * @return string 'treeAndVegetationCuttingWork'
     */
    const VALUE_TREE_AND_VEGETATION_CUTTING_WORK = 'treeAndVegetationCuttingWork';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLEARANCE_WORK
     * @uses self::VALUE_CONTROLLED_AVALANCHE
     * @uses self::VALUE_INSTALLATION_WORK
     * @uses self::VALUE_GRASS_CUTTING_WORK
     * @uses self::VALUE_MAINTENANCE_WORK
     * @uses self::VALUE_OVERHEAD_WORKS
     * @uses self::VALUE_REPAIR_WORK
     * @uses self::VALUE_RESURFACING_WORK
     * @uses self::VALUE_ROAD_MARKING_WORK
     * @uses self::VALUE_ROADSIDE_WORK
     * @uses self::VALUE_ROADWORKS_CLEARANCE
     * @uses self::VALUE_ROADWORKS
     * @uses self::VALUE_ROCK_FALL_PREVENTATIVE_MAINTENANCE
     * @uses self::VALUE_SALTING_IN_PROGRESS
     * @uses self::VALUE_SNOWPLOUGHS_IN_USE
     * @uses self::VALUE_TREE_AND_VEGETATION_CUTTING_WORK
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLEARANCE_WORK,
            self::VALUE_CONTROLLED_AVALANCHE,
            self::VALUE_INSTALLATION_WORK,
            self::VALUE_GRASS_CUTTING_WORK,
            self::VALUE_MAINTENANCE_WORK,
            self::VALUE_OVERHEAD_WORKS,
            self::VALUE_REPAIR_WORK,
            self::VALUE_RESURFACING_WORK,
            self::VALUE_ROAD_MARKING_WORK,
            self::VALUE_ROADSIDE_WORK,
            self::VALUE_ROADWORKS_CLEARANCE,
            self::VALUE_ROADWORKS,
            self::VALUE_ROCK_FALL_PREVENTATIVE_MAINTENANCE,
            self::VALUE_SALTING_IN_PROGRESS,
            self::VALUE_SNOWPLOUGHS_IN_USE,
            self::VALUE_TREE_AND_VEGETATION_CUTTING_WORK,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
