<?php

namespace EnumType;

/**
 * This class stands for RetailFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Retail Facility.
 * @subpackage Enumerations
 */
class RetailFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'food'
     * @return string 'food'
     */
    const VALUE_FOOD = 'food';
    /**
     * Constant for value 'newspaperTobacco'
     * @return string 'newspaperTobacco'
     */
    const VALUE_NEWSPAPER_TOBACCO = 'newspaperTobacco';
    /**
     * Constant for value 'recreationTravel'
     * @return string 'recreationTravel'
     */
    const VALUE_RECREATION_TRAVEL = 'recreationTravel';
    /**
     * Constant for value 'hygieneHealthBeauty'
     * @return string 'hygieneHealthBeauty'
     */
    const VALUE_HYGIENE_HEALTH_BEAUTY = 'hygieneHealthBeauty';
    /**
     * Constant for value 'fashionAccessories'
     * @return string 'fashionAccessories'
     */
    const VALUE_FASHION_ACCESSORIES = 'fashionAccessories';
    /**
     * Constant for value 'bankFinanceInsurance'
     * @return string 'bankFinanceInsurance'
     */
    const VALUE_BANK_FINANCE_INSURANCE = 'bankFinanceInsurance';
    /**
     * Constant for value 'cashMachine'
     * @return string 'cashMachine'
     */
    const VALUE_CASH_MACHINE = 'cashMachine';
    /**
     * Constant for value 'currencyExchange'
     * @return string 'currencyExchange'
     */
    const VALUE_CURRENCY_EXCHANGE = 'currencyExchange';
    /**
     * Constant for value 'tourismService'
     * @return string 'tourismService'
     */
    const VALUE_TOURISM_SERVICE = 'tourismService';
    /**
     * Constant for value 'photoBooth'
     * @return string 'photoBooth'
     */
    const VALUE_PHOTO_BOOTH = 'photoBooth';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FOOD
     * @uses self::VALUE_NEWSPAPER_TOBACCO
     * @uses self::VALUE_RECREATION_TRAVEL
     * @uses self::VALUE_HYGIENE_HEALTH_BEAUTY
     * @uses self::VALUE_FASHION_ACCESSORIES
     * @uses self::VALUE_BANK_FINANCE_INSURANCE
     * @uses self::VALUE_CASH_MACHINE
     * @uses self::VALUE_CURRENCY_EXCHANGE
     * @uses self::VALUE_TOURISM_SERVICE
     * @uses self::VALUE_PHOTO_BOOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FOOD,
            self::VALUE_NEWSPAPER_TOBACCO,
            self::VALUE_RECREATION_TRAVEL,
            self::VALUE_HYGIENE_HEALTH_BEAUTY,
            self::VALUE_FASHION_ACCESSORIES,
            self::VALUE_BANK_FINANCE_INSURANCE,
            self::VALUE_CASH_MACHINE,
            self::VALUE_CURRENCY_EXCHANGE,
            self::VALUE_TOURISM_SERVICE,
            self::VALUE_PHOTO_BOOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
