<?php

namespace EnumType;

/**
 * This class stands for RelationToVehicleEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of Relation to VEHICLE of STOPPING POSITION.
 * @subpackage Enumerations
 */
class RelationToVehicleEnumeration
{
    /**
     * Constant for value 'frontLeft'
     * @return string 'frontLeft'
     */
    const VALUE_FRONT_LEFT = 'frontLeft';
    /**
     * Constant for value 'frontRight'
     * @return string 'frontRight'
     */
    const VALUE_FRONT_RIGHT = 'frontRight';
    /**
     * Constant for value 'backRight'
     * @return string 'backRight'
     */
    const VALUE_BACK_RIGHT = 'backRight';
    /**
     * Constant for value 'driverLeft'
     * @return string 'driverLeft'
     */
    const VALUE_DRIVER_LEFT = 'driverLeft';
    /**
     * Constant for value 'driverRight'
     * @return string 'driverRight'
     */
    const VALUE_DRIVER_RIGHT = 'driverRight';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FRONT_LEFT
     * @uses self::VALUE_FRONT_RIGHT
     * @uses self::VALUE_BACK_RIGHT
     * @uses self::VALUE_DRIVER_LEFT
     * @uses self::VALUE_DRIVER_RIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FRONT_LEFT,
            self::VALUE_FRONT_RIGHT,
            self::VALUE_BACK_RIGHT,
            self::VALUE_DRIVER_LEFT,
            self::VALUE_DRIVER_RIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
