<?php

namespace EnumType;

/**
 * This class stands for RelatedToEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Type of Source.
 * @subpackage Enumerations
 */
class RelatedToEnumeration
{
    /**
     * Constant for value 'cause'
     * @return string 'cause'
     */
    const VALUE_CAUSE = 'cause';
    /**
     * Constant for value 'effect'
     * @return string 'effect'
     */
    const VALUE_EFFECT = 'effect';
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'supercedes'
     * @return string 'supercedes'
     */
    const VALUE_SUPERCEDES = 'supercedes';
    /**
     * Constant for value 'supercededBy'
     * @return string 'supercededBy'
     */
    const VALUE_SUPERCEDED_BY = 'supercededBy';
    /**
     * Constant for value 'associated'
     * @return string 'associated'
     */
    const VALUE_ASSOCIATED = 'associated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAUSE
     * @uses self::VALUE_EFFECT
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_SUPERCEDES
     * @uses self::VALUE_SUPERCEDED_BY
     * @uses self::VALUE_ASSOCIATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAUSE,
            self::VALUE_EFFECT,
            self::VALUE_UPDATE,
            self::VALUE_SUPERCEDES,
            self::VALUE_SUPERCEDED_BY,
            self::VALUE_ASSOCIATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
