<?php

namespace EnumType;

/**
 * This class stands for PollutantTypeEnum EnumType
 * @subpackage Enumerations
 */
class PollutantTypeEnum
{
    /**
     * Constant for value 'benzeneTolueneXylene'
     * @return string 'benzeneTolueneXylene'
     */
    const VALUE_BENZENE_TOLUENE_XYLENE = 'benzeneTolueneXylene';
    /**
     * Constant for value 'carbonMonoxide'
     * @return string 'carbonMonoxide'
     */
    const VALUE_CARBON_MONOXIDE = 'carbonMonoxide';
    /**
     * Constant for value 'lead'
     * @return string 'lead'
     */
    const VALUE_LEAD = 'lead';
    /**
     * Constant for value 'methane'
     * @return string 'methane'
     */
    const VALUE_METHANE = 'methane';
    /**
     * Constant for value 'nitricOxide'
     * @return string 'nitricOxide'
     */
    const VALUE_NITRIC_OXIDE = 'nitricOxide';
    /**
     * Constant for value 'nitrogenDioxide'
     * @return string 'nitrogenDioxide'
     */
    const VALUE_NITROGEN_DIOXIDE = 'nitrogenDioxide';
    /**
     * Constant for value 'nitrogenMonoxide'
     * @return string 'nitrogenMonoxide'
     */
    const VALUE_NITROGEN_MONOXIDE = 'nitrogenMonoxide';
    /**
     * Constant for value 'nitrogenOxides'
     * @return string 'nitrogenOxides'
     */
    const VALUE_NITROGEN_OXIDES = 'nitrogenOxides';
    /**
     * Constant for value 'nonMethaneHydrocarbons'
     * @return string 'nonMethaneHydrocarbons'
     */
    const VALUE_NON_METHANE_HYDROCARBONS = 'nonMethaneHydrocarbons';
    /**
     * Constant for value 'ozone'
     * @return string 'ozone'
     */
    const VALUE_OZONE = 'ozone';
    /**
     * Constant for value 'particulates10'
     * @return string 'particulates10'
     */
    const VALUE_PARTICULATES_10 = 'particulates10';
    /**
     * Constant for value 'polycyclicAromaticHydrocarbons'
     * @return string 'polycyclicAromaticHydrocarbons'
     */
    const VALUE_POLYCYCLIC_AROMATIC_HYDROCARBONS = 'polycyclicAromaticHydrocarbons';
    /**
     * Constant for value 'primaryParticulate'
     * @return string 'primaryParticulate'
     */
    const VALUE_PRIMARY_PARTICULATE = 'primaryParticulate';
    /**
     * Constant for value 'sulphurDioxide'
     * @return string 'sulphurDioxide'
     */
    const VALUE_SULPHUR_DIOXIDE = 'sulphurDioxide';
    /**
     * Constant for value 'totalHydrocarbons'
     * @return string 'totalHydrocarbons'
     */
    const VALUE_TOTAL_HYDROCARBONS = 'totalHydrocarbons';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BENZENE_TOLUENE_XYLENE
     * @uses self::VALUE_CARBON_MONOXIDE
     * @uses self::VALUE_LEAD
     * @uses self::VALUE_METHANE
     * @uses self::VALUE_NITRIC_OXIDE
     * @uses self::VALUE_NITROGEN_DIOXIDE
     * @uses self::VALUE_NITROGEN_MONOXIDE
     * @uses self::VALUE_NITROGEN_OXIDES
     * @uses self::VALUE_NON_METHANE_HYDROCARBONS
     * @uses self::VALUE_OZONE
     * @uses self::VALUE_PARTICULATES_10
     * @uses self::VALUE_POLYCYCLIC_AROMATIC_HYDROCARBONS
     * @uses self::VALUE_PRIMARY_PARTICULATE
     * @uses self::VALUE_SULPHUR_DIOXIDE
     * @uses self::VALUE_TOTAL_HYDROCARBONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BENZENE_TOLUENE_XYLENE,
            self::VALUE_CARBON_MONOXIDE,
            self::VALUE_LEAD,
            self::VALUE_METHANE,
            self::VALUE_NITRIC_OXIDE,
            self::VALUE_NITROGEN_DIOXIDE,
            self::VALUE_NITROGEN_MONOXIDE,
            self::VALUE_NITROGEN_OXIDES,
            self::VALUE_NON_METHANE_HYDROCARBONS,
            self::VALUE_OZONE,
            self::VALUE_PARTICULATES_10,
            self::VALUE_POLYCYCLIC_AROMATIC_HYDROCARBONS,
            self::VALUE_PRIMARY_PARTICULATE,
            self::VALUE_SULPHUR_DIOXIDE,
            self::VALUE_TOTAL_HYDROCARBONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
