<?php

namespace EnumType;

/**
 * This class stands for PlacesEnum EnumType
 * @subpackage Enumerations
 */
class PlacesEnum
{
    /**
     * Constant for value 'aroundBendsInTheRoad'
     * @return string 'aroundBendsInTheRoad'
     */
    const VALUE_AROUND_BENDS_IN_THE_ROAD = 'aroundBendsInTheRoad';
    /**
     * Constant for value 'atCustomsPosts'
     * @return string 'atCustomsPosts'
     */
    const VALUE_AT_CUSTOMS_POSTS = 'atCustomsPosts';
    /**
     * Constant for value 'atHighAltitudes'
     * @return string 'atHighAltitudes'
     */
    const VALUE_AT_HIGH_ALTITUDES = 'atHighAltitudes';
    /**
     * Constant for value 'atTollPlazas'
     * @return string 'atTollPlazas'
     */
    const VALUE_AT_TOLL_PLAZAS = 'atTollPlazas';
    /**
     * Constant for value 'inGalleries'
     * @return string 'inGalleries'
     */
    const VALUE_IN_GALLERIES = 'inGalleries';
    /**
     * Constant for value 'inLowLyingAreas'
     * @return string 'inLowLyingAreas'
     */
    const VALUE_IN_LOW_LYING_AREAS = 'inLowLyingAreas';
    /**
     * Constant for value 'inRoadworksAreas'
     * @return string 'inRoadworksAreas'
     */
    const VALUE_IN_ROADWORKS_AREAS = 'inRoadworksAreas';
    /**
     * Constant for value 'inShadedAreas'
     * @return string 'inShadedAreas'
     */
    const VALUE_IN_SHADED_AREAS = 'inShadedAreas';
    /**
     * Constant for value 'inTheCityCentre'
     * @return string 'inTheCityCentre'
     */
    const VALUE_IN_THE_CITY_CENTRE = 'inTheCityCentre';
    /**
     * Constant for value 'inTheInnerCityAreas'
     * @return string 'inTheInnerCityAreas'
     */
    const VALUE_IN_THE_INNER_CITY_AREAS = 'inTheInnerCityAreas';
    /**
     * Constant for value 'inTunnels'
     * @return string 'inTunnels'
     */
    const VALUE_IN_TUNNELS = 'inTunnels';
    /**
     * Constant for value 'onBridges'
     * @return string 'onBridges'
     */
    const VALUE_ON_BRIDGES = 'onBridges';
    /**
     * Constant for value 'onElevatedSections'
     * @return string 'onElevatedSections'
     */
    const VALUE_ON_ELEVATED_SECTIONS = 'onElevatedSections';
    /**
     * Constant for value 'onEnteringOrLeavingTunnels'
     * @return string 'onEnteringOrLeavingTunnels'
     */
    const VALUE_ON_ENTERING_OR_LEAVING_TUNNELS = 'onEnteringOrLeavingTunnels';
    /**
     * Constant for value 'onEnteringTheCountry'
     * @return string 'onEnteringTheCountry'
     */
    const VALUE_ON_ENTERING_THE_COUNTRY = 'onEnteringTheCountry';
    /**
     * Constant for value 'onFlyovers'
     * @return string 'onFlyovers'
     */
    const VALUE_ON_FLYOVERS = 'onFlyovers';
    /**
     * Constant for value 'onLeavingTheCountry'
     * @return string 'onLeavingTheCountry'
     */
    const VALUE_ON_LEAVING_THE_COUNTRY = 'onLeavingTheCountry';
    /**
     * Constant for value 'onMotorways'
     * @return string 'onMotorways'
     */
    const VALUE_ON_MOTORWAYS = 'onMotorways';
    /**
     * Constant for value 'onNonMotorways'
     * @return string 'onNonMotorways'
     */
    const VALUE_ON_NON_MOTORWAYS = 'onNonMotorways';
    /**
     * Constant for value 'onRoundabouts'
     * @return string 'onRoundabouts'
     */
    const VALUE_ON_ROUNDABOUTS = 'onRoundabouts';
    /**
     * Constant for value 'onSlipRoads'
     * @return string 'onSlipRoads'
     */
    const VALUE_ON_SLIP_ROADS = 'onSlipRoads';
    /**
     * Constant for value 'onUndergroundSections'
     * @return string 'onUndergroundSections'
     */
    const VALUE_ON_UNDERGROUND_SECTIONS = 'onUndergroundSections';
    /**
     * Constant for value 'onUnderpasses'
     * @return string 'onUnderpasses'
     */
    const VALUE_ON_UNDERPASSES = 'onUnderpasses';
    /**
     * Constant for value 'overTheCrestOfHills'
     * @return string 'overTheCrestOfHills'
     */
    const VALUE_OVER_THE_CREST_OF_HILLS = 'overTheCrestOfHills';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AROUND_BENDS_IN_THE_ROAD
     * @uses self::VALUE_AT_CUSTOMS_POSTS
     * @uses self::VALUE_AT_HIGH_ALTITUDES
     * @uses self::VALUE_AT_TOLL_PLAZAS
     * @uses self::VALUE_IN_GALLERIES
     * @uses self::VALUE_IN_LOW_LYING_AREAS
     * @uses self::VALUE_IN_ROADWORKS_AREAS
     * @uses self::VALUE_IN_SHADED_AREAS
     * @uses self::VALUE_IN_THE_CITY_CENTRE
     * @uses self::VALUE_IN_THE_INNER_CITY_AREAS
     * @uses self::VALUE_IN_TUNNELS
     * @uses self::VALUE_ON_BRIDGES
     * @uses self::VALUE_ON_ELEVATED_SECTIONS
     * @uses self::VALUE_ON_ENTERING_OR_LEAVING_TUNNELS
     * @uses self::VALUE_ON_ENTERING_THE_COUNTRY
     * @uses self::VALUE_ON_FLYOVERS
     * @uses self::VALUE_ON_LEAVING_THE_COUNTRY
     * @uses self::VALUE_ON_MOTORWAYS
     * @uses self::VALUE_ON_NON_MOTORWAYS
     * @uses self::VALUE_ON_ROUNDABOUTS
     * @uses self::VALUE_ON_SLIP_ROADS
     * @uses self::VALUE_ON_UNDERGROUND_SECTIONS
     * @uses self::VALUE_ON_UNDERPASSES
     * @uses self::VALUE_OVER_THE_CREST_OF_HILLS
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AROUND_BENDS_IN_THE_ROAD,
            self::VALUE_AT_CUSTOMS_POSTS,
            self::VALUE_AT_HIGH_ALTITUDES,
            self::VALUE_AT_TOLL_PLAZAS,
            self::VALUE_IN_GALLERIES,
            self::VALUE_IN_LOW_LYING_AREAS,
            self::VALUE_IN_ROADWORKS_AREAS,
            self::VALUE_IN_SHADED_AREAS,
            self::VALUE_IN_THE_CITY_CENTRE,
            self::VALUE_IN_THE_INNER_CITY_AREAS,
            self::VALUE_IN_TUNNELS,
            self::VALUE_ON_BRIDGES,
            self::VALUE_ON_ELEVATED_SECTIONS,
            self::VALUE_ON_ENTERING_OR_LEAVING_TUNNELS,
            self::VALUE_ON_ENTERING_THE_COUNTRY,
            self::VALUE_ON_FLYOVERS,
            self::VALUE_ON_LEAVING_THE_COUNTRY,
            self::VALUE_ON_MOTORWAYS,
            self::VALUE_ON_NON_MOTORWAYS,
            self::VALUE_ON_ROUNDABOUTS,
            self::VALUE_ON_SLIP_ROADS,
            self::VALUE_ON_UNDERGROUND_SECTIONS,
            self::VALUE_ON_UNDERPASSES,
            self::VALUE_OVER_THE_CREST_OF_HILLS,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
