<?php

namespace EnumType;

/**
 * This class stands for PersonnelSubReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Personnel incident sub reason types.
 * @subpackage Enumerations
 */
class PersonnelSubReasonEnumeration
{
    /**
     * Constant for value 'staffSickness'
     * @return string 'staffSickness'
     */
    const VALUE_STAFF_SICKNESS = 'staffSickness';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'staffInjury'
     * @return string 'staffInjury'
     */
    const VALUE_STAFF_INJURY = 'staffInjury';
    /**
     * Constant for value 'contractorStaffInjury'
     * @return string 'contractorStaffInjury'
     */
    const VALUE_CONTRACTOR_STAFF_INJURY = 'contractorStaffInjury';
    /**
     * Constant for value 'staffAbsence'
     * @return string 'staffAbsence'
     */
    const VALUE_STAFF_ABSENCE = 'staffAbsence';
    /**
     * Constant for value 'staffInWrongPlace'
     * @return string 'staffInWrongPlace'
     */
    const VALUE_STAFF_IN_WRONG_PLACE = 'staffInWrongPlace';
    /**
     * Constant for value 'staffShortage'
     * @return string 'staffShortage'
     */
    const VALUE_STAFF_SHORTAGE = 'staffShortage';
    /**
     * Constant for value 'industrialAction'
     * @return string 'industrialAction'
     */
    const VALUE_INDUSTRIAL_ACTION = 'industrialAction';
    /**
     * Constant for value 'unofficialIndustrialAction'
     * @return string 'unofficialIndustrialAction'
     */
    const VALUE_UNOFFICIAL_INDUSTRIAL_ACTION = 'unofficialIndustrialAction';
    /**
     * Constant for value 'workToRule'
     * @return string 'workToRule'
     */
    const VALUE_WORK_TO_RULE = 'workToRule';
    /**
     * Constant for value 'undefinedPersonnelProblem'
     * @return string 'undefinedPersonnelProblem'
     */
    const VALUE_UNDEFINED_PERSONNEL_PROBLEM = 'undefinedPersonnelProblem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STAFF_SICKNESS
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_STAFF_INJURY
     * @uses self::VALUE_CONTRACTOR_STAFF_INJURY
     * @uses self::VALUE_STAFF_ABSENCE
     * @uses self::VALUE_STAFF_IN_WRONG_PLACE
     * @uses self::VALUE_STAFF_SHORTAGE
     * @uses self::VALUE_INDUSTRIAL_ACTION
     * @uses self::VALUE_UNOFFICIAL_INDUSTRIAL_ACTION
     * @uses self::VALUE_WORK_TO_RULE
     * @uses self::VALUE_UNDEFINED_PERSONNEL_PROBLEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STAFF_SICKNESS,
            self::VALUE_UNKNOWN,
            self::VALUE_STAFF_INJURY,
            self::VALUE_CONTRACTOR_STAFF_INJURY,
            self::VALUE_STAFF_ABSENCE,
            self::VALUE_STAFF_IN_WRONG_PLACE,
            self::VALUE_STAFF_SHORTAGE,
            self::VALUE_INDUSTRIAL_ACTION,
            self::VALUE_UNOFFICIAL_INDUSTRIAL_ACTION,
            self::VALUE_WORK_TO_RULE,
            self::VALUE_UNDEFINED_PERSONNEL_PROBLEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
