<?php

namespace EnumType;

/**
 * This class stands for PersonnelReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Personnel incident reason types TPEG Pti18_2/TPEG Pti_20.
 * @subpackage Enumerations
 */
class PersonnelReasonEnumeration
{
    /**
     * Constant for value 'pti20_0'
     * @return string 'pti20_0'
     */
    const VALUE_PTI_20_0 = 'pti20_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti20_1'
     * @return string 'pti20_1'
     */
    const VALUE_PTI_20_1 = 'pti20_1';
    /**
     * Constant for value 'staffSickness'
     * @return string 'staffSickness'
     */
    const VALUE_STAFF_SICKNESS = 'staffSickness';
    /**
     * Constant for value 'pti20_1_Alias_1'
     * @return string 'pti20_1_Alias_1'
     */
    const VALUE_PTI_20_1_ALIAS_1 = 'pti20_1_Alias_1';
    /**
     * Constant for value 'staffInjury'
     * @return string 'staffInjury'
     */
    const VALUE_STAFF_INJURY = 'staffInjury';
    /**
     * Constant for value 'pti20_1_Alias_2'
     * @return string 'pti20_1_Alias_2'
     */
    const VALUE_PTI_20_1_ALIAS_2 = 'pti20_1_Alias_2';
    /**
     * Constant for value 'contractorStaffInjury'
     * @return string 'contractorStaffInjury'
     */
    const VALUE_CONTRACTOR_STAFF_INJURY = 'contractorStaffInjury';
    /**
     * Constant for value 'pti20_2'
     * @return string 'pti20_2'
     */
    const VALUE_PTI_20_2 = 'pti20_2';
    /**
     * Constant for value 'staffAbsence'
     * @return string 'staffAbsence'
     */
    const VALUE_STAFF_ABSENCE = 'staffAbsence';
    /**
     * Constant for value 'pti20_3'
     * @return string 'pti20_3'
     */
    const VALUE_PTI_20_3 = 'pti20_3';
    /**
     * Constant for value 'staffInWrongPlace'
     * @return string 'staffInWrongPlace'
     */
    const VALUE_STAFF_IN_WRONG_PLACE = 'staffInWrongPlace';
    /**
     * Constant for value 'pti20_4'
     * @return string 'pti20_4'
     */
    const VALUE_PTI_20_4 = 'pti20_4';
    /**
     * Constant for value 'staffShortage'
     * @return string 'staffShortage'
     */
    const VALUE_STAFF_SHORTAGE = 'staffShortage';
    /**
     * Constant for value 'pti20_5'
     * @return string 'pti20_5'
     */
    const VALUE_PTI_20_5 = 'pti20_5';
    /**
     * Constant for value 'industrialAction'
     * @return string 'industrialAction'
     */
    const VALUE_INDUSTRIAL_ACTION = 'industrialAction';
    /**
     * Constant for value 'pti20_5_Alias_1'
     * @return string 'pti20_5_Alias_1'
     */
    const VALUE_PTI_20_5_ALIAS_1 = 'pti20_5_Alias_1';
    /**
     * Constant for value 'unofficialIndustrialAction'
     * @return string 'unofficialIndustrialAction'
     */
    const VALUE_UNOFFICIAL_INDUSTRIAL_ACTION = 'unofficialIndustrialAction';
    /**
     * Constant for value 'pti20_6'
     * @return string 'pti20_6'
     */
    const VALUE_PTI_20_6 = 'pti20_6';
    /**
     * Constant for value 'workToRule'
     * @return string 'workToRule'
     */
    const VALUE_WORK_TO_RULE = 'workToRule';
    /**
     * Constant for value 'pti20_255'
     * @return string 'pti20_255'
     */
    const VALUE_PTI_20_255 = 'pti20_255';
    /**
     * Constant for value 'undefinedPersonnelProblem'
     * @return string 'undefinedPersonnelProblem'
     */
    const VALUE_UNDEFINED_PERSONNEL_PROBLEM = 'undefinedPersonnelProblem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_20_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_20_1
     * @uses self::VALUE_STAFF_SICKNESS
     * @uses self::VALUE_PTI_20_1_ALIAS_1
     * @uses self::VALUE_STAFF_INJURY
     * @uses self::VALUE_PTI_20_1_ALIAS_2
     * @uses self::VALUE_CONTRACTOR_STAFF_INJURY
     * @uses self::VALUE_PTI_20_2
     * @uses self::VALUE_STAFF_ABSENCE
     * @uses self::VALUE_PTI_20_3
     * @uses self::VALUE_STAFF_IN_WRONG_PLACE
     * @uses self::VALUE_PTI_20_4
     * @uses self::VALUE_STAFF_SHORTAGE
     * @uses self::VALUE_PTI_20_5
     * @uses self::VALUE_INDUSTRIAL_ACTION
     * @uses self::VALUE_PTI_20_5_ALIAS_1
     * @uses self::VALUE_UNOFFICIAL_INDUSTRIAL_ACTION
     * @uses self::VALUE_PTI_20_6
     * @uses self::VALUE_WORK_TO_RULE
     * @uses self::VALUE_PTI_20_255
     * @uses self::VALUE_UNDEFINED_PERSONNEL_PROBLEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_20_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_20_1,
            self::VALUE_STAFF_SICKNESS,
            self::VALUE_PTI_20_1_ALIAS_1,
            self::VALUE_STAFF_INJURY,
            self::VALUE_PTI_20_1_ALIAS_2,
            self::VALUE_CONTRACTOR_STAFF_INJURY,
            self::VALUE_PTI_20_2,
            self::VALUE_STAFF_ABSENCE,
            self::VALUE_PTI_20_3,
            self::VALUE_STAFF_IN_WRONG_PLACE,
            self::VALUE_PTI_20_4,
            self::VALUE_STAFF_SHORTAGE,
            self::VALUE_PTI_20_5,
            self::VALUE_INDUSTRIAL_ACTION,
            self::VALUE_PTI_20_5_ALIAS_1,
            self::VALUE_UNOFFICIAL_INDUSTRIAL_ACTION,
            self::VALUE_PTI_20_6,
            self::VALUE_WORK_TO_RULE,
            self::VALUE_PTI_20_255,
            self::VALUE_UNDEFINED_PERSONNEL_PROBLEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
