<?php

namespace EnumType;

/**
 * This class stands for PathUpDownEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for path heading.
 * @subpackage Enumerations
 */
class PathUpDownEnumeration
{
    /**
     * Constant for value 'up'
     * @return string 'up'
     */
    const VALUE_UP = 'up';
    /**
     * Constant for value 'down'
     * @return string 'down'
     */
    const VALUE_DOWN = 'down';
    /**
     * Constant for value 'level'
     * @return string 'level'
     */
    const VALUE_LEVEL = 'level';
    /**
     * Constant for value 'upAndDown'
     * @return string 'upAndDown'
     */
    const VALUE_UP_AND_DOWN = 'upAndDown';
    /**
     * Constant for value 'downAndUp'
     * @return string 'downAndUp'
     */
    const VALUE_DOWN_AND_UP = 'downAndUp';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UP
     * @uses self::VALUE_DOWN
     * @uses self::VALUE_LEVEL
     * @uses self::VALUE_UP_AND_DOWN
     * @uses self::VALUE_DOWN_AND_UP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UP,
            self::VALUE_DOWN,
            self::VALUE_LEVEL,
            self::VALUE_UP_AND_DOWN,
            self::VALUE_DOWN_AND_UP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
