<?php

namespace EnumType;

/**
 * This class stands for PassengerCommsFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for PassengerComms Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class PassengerCommsFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'faccomms_1'
     * @return string 'faccomms_1'
     */
    const VALUE_FACCOMMS_1 = 'faccomms_1';
    /**
     * Constant for value 'passengerWifi'
     * @return string 'passengerWifi'
     */
    const VALUE_PASSENGER_WIFI = 'passengerWifi';
    /**
     * Constant for value 'pti23_21'
     * @return string 'pti23_21'
     */
    const VALUE_PTI_23_21 = 'pti23_21';
    /**
     * Constant for value 'telephone'
     * @return string 'telephone'
     */
    const VALUE_TELEPHONE = 'telephone';
    /**
     * Constant for value 'pti23_14'
     * @return string 'pti23_14'
     */
    const VALUE_PTI_23_14 = 'pti23_14';
    /**
     * Constant for value 'audioServices'
     * @return string 'audioServices'
     */
    const VALUE_AUDIO_SERVICES = 'audioServices';
    /**
     * Constant for value 'pti23_15'
     * @return string 'pti23_15'
     */
    const VALUE_PTI_23_15 = 'pti23_15';
    /**
     * Constant for value 'videoServices'
     * @return string 'videoServices'
     */
    const VALUE_VIDEO_SERVICES = 'videoServices';
    /**
     * Constant for value 'pti23_25'
     * @return string 'pti23_25'
     */
    const VALUE_PTI_23_25 = 'pti23_25';
    /**
     * Constant for value 'businessServices'
     * @return string 'businessServices'
     */
    const VALUE_BUSINESS_SERVICES = 'businessServices';
    /**
     * Constant for value 'internet'
     * @return string 'internet'
     */
    const VALUE_INTERNET = 'internet';
    /**
     * Constant for value 'postoffice'
     * @return string 'postoffice'
     */
    const VALUE_POSTOFFICE = 'postoffice';
    /**
     * Constant for value 'letterbox'
     * @return string 'letterbox'
     */
    const VALUE_LETTERBOX = 'letterbox';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FACCOMMS_1
     * @uses self::VALUE_PASSENGER_WIFI
     * @uses self::VALUE_PTI_23_21
     * @uses self::VALUE_TELEPHONE
     * @uses self::VALUE_PTI_23_14
     * @uses self::VALUE_AUDIO_SERVICES
     * @uses self::VALUE_PTI_23_15
     * @uses self::VALUE_VIDEO_SERVICES
     * @uses self::VALUE_PTI_23_25
     * @uses self::VALUE_BUSINESS_SERVICES
     * @uses self::VALUE_INTERNET
     * @uses self::VALUE_POSTOFFICE
     * @uses self::VALUE_LETTERBOX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FACCOMMS_1,
            self::VALUE_PASSENGER_WIFI,
            self::VALUE_PTI_23_21,
            self::VALUE_TELEPHONE,
            self::VALUE_PTI_23_14,
            self::VALUE_AUDIO_SERVICES,
            self::VALUE_PTI_23_15,
            self::VALUE_VIDEO_SERVICES,
            self::VALUE_PTI_23_25,
            self::VALUE_BUSINESS_SERVICES,
            self::VALUE_INTERNET,
            self::VALUE_POSTOFFICE,
            self::VALUE_LETTERBOX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
