<?php

namespace EnumType;

/**
 * This class stands for PassageTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of Passage Types.
 * @subpackage Enumerations
 */
class PassageTypeEnumeration
{
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'pathway'
     * @return string 'pathway'
     */
    const VALUE_PATHWAY = 'pathway';
    /**
     * Constant for value 'corridor'
     * @return string 'corridor'
     */
    const VALUE_CORRIDOR = 'corridor';
    /**
     * Constant for value 'overpass'
     * @return string 'overpass'
     */
    const VALUE_OVERPASS = 'overpass';
    /**
     * Constant for value 'underpass'
     * @return string 'underpass'
     */
    const VALUE_UNDERPASS = 'underpass';
    /**
     * Constant for value 'tunnel'
     * @return string 'tunnel'
     */
    const VALUE_TUNNEL = 'tunnel';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_PATHWAY
     * @uses self::VALUE_CORRIDOR
     * @uses self::VALUE_OVERPASS
     * @uses self::VALUE_UNDERPASS
     * @uses self::VALUE_TUNNEL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_PATHWAY,
            self::VALUE_CORRIDOR,
            self::VALUE_OVERPASS,
            self::VALUE_UNDERPASS,
            self::VALUE_TUNNEL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
