<?php

namespace EnumType;

/**
 * This class stands for OccupancyEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Passenger load status of a VEHICLE.
 * @subpackage Enumerations
 */
class OccupancyEnumeration
{
    /**
     * Constant for value 'full'
     * @return string 'full'
     */
    const VALUE_FULL = 'full';
    /**
     * Constant for value 'seatsAvailable'
     * @return string 'seatsAvailable'
     */
    const VALUE_SEATS_AVAILABLE = 'seatsAvailable';
    /**
     * Constant for value 'standingAvailable'
     * @return string 'standingAvailable'
     */
    const VALUE_STANDING_AVAILABLE = 'standingAvailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL
     * @uses self::VALUE_SEATS_AVAILABLE
     * @uses self::VALUE_STANDING_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL,
            self::VALUE_SEATS_AVAILABLE,
            self::VALUE_STANDING_AVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
