<?php

namespace EnumType;

/**
 * This class stands for NuisanceFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Nuisance Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class NuisanceFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'smoking'
     * @return string 'smoking'
     */
    const VALUE_SMOKING = 'smoking';
    /**
     * Constant for value 'noSmoking'
     * @return string 'noSmoking'
     */
    const VALUE_NO_SMOKING = 'noSmoking';
    /**
     * Constant for value 'mobilePhoneUseZone'
     * @return string 'mobilePhoneUseZone'
     */
    const VALUE_MOBILE_PHONE_USE_ZONE = 'mobilePhoneUseZone';
    /**
     * Constant for value 'mobilePhoneFreeZone'
     * @return string 'mobilePhoneFreeZone'
     */
    const VALUE_MOBILE_PHONE_FREE_ZONE = 'mobilePhoneFreeZone';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_SMOKING
     * @uses self::VALUE_NO_SMOKING
     * @uses self::VALUE_MOBILE_PHONE_USE_ZONE
     * @uses self::VALUE_MOBILE_PHONE_FREE_ZONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_SMOKING,
            self::VALUE_NO_SMOKING,
            self::VALUE_MOBILE_PHONE_USE_ZONE,
            self::VALUE_MOBILE_PHONE_FREE_ZONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
