<?php

namespace EnumType;

/**
 * This class stands for MonthOfYearEnum EnumType
 * @subpackage Enumerations
 */
class MonthOfYearEnum
{
    /**
     * Constant for value 'january'
     * @return string 'january'
     */
    const VALUE_JANUARY = 'january';
    /**
     * Constant for value 'february'
     * @return string 'february'
     */
    const VALUE_FEBRUARY = 'february';
    /**
     * Constant for value 'march'
     * @return string 'march'
     */
    const VALUE_MARCH = 'march';
    /**
     * Constant for value 'april'
     * @return string 'april'
     */
    const VALUE_APRIL = 'april';
    /**
     * Constant for value 'may'
     * @return string 'may'
     */
    const VALUE_MAY = 'may';
    /**
     * Constant for value 'june'
     * @return string 'june'
     */
    const VALUE_JUNE = 'june';
    /**
     * Constant for value 'july'
     * @return string 'july'
     */
    const VALUE_JULY = 'july';
    /**
     * Constant for value 'august'
     * @return string 'august'
     */
    const VALUE_AUGUST = 'august';
    /**
     * Constant for value 'september'
     * @return string 'september'
     */
    const VALUE_SEPTEMBER = 'september';
    /**
     * Constant for value 'october'
     * @return string 'october'
     */
    const VALUE_OCTOBER = 'october';
    /**
     * Constant for value 'november'
     * @return string 'november'
     */
    const VALUE_NOVEMBER = 'november';
    /**
     * Constant for value 'december'
     * @return string 'december'
     */
    const VALUE_DECEMBER = 'december';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_JANUARY
     * @uses self::VALUE_FEBRUARY
     * @uses self::VALUE_MARCH
     * @uses self::VALUE_APRIL
     * @uses self::VALUE_MAY
     * @uses self::VALUE_JUNE
     * @uses self::VALUE_JULY
     * @uses self::VALUE_AUGUST
     * @uses self::VALUE_SEPTEMBER
     * @uses self::VALUE_OCTOBER
     * @uses self::VALUE_NOVEMBER
     * @uses self::VALUE_DECEMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JANUARY,
            self::VALUE_FEBRUARY,
            self::VALUE_MARCH,
            self::VALUE_APRIL,
            self::VALUE_MAY,
            self::VALUE_JUNE,
            self::VALUE_JULY,
            self::VALUE_AUGUST,
            self::VALUE_SEPTEMBER,
            self::VALUE_OCTOBER,
            self::VALUE_NOVEMBER,
            self::VALUE_DECEMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
