<?php

namespace EnumType;

/**
 * This class stands for MiscellaneousReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Miscellaneous incident reason types TPEG Pti18_1/TPEG Pti_19.
 * @subpackage Enumerations
 */
class MiscellaneousReasonEnumeration
{
    /**
     * Constant for value 'pti19_0'
     * @return string 'pti19_0'
     */
    const VALUE_PTI_19_0 = 'pti19_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti19_0_1'
     * @return string 'pti19_0_1'
     */
    const VALUE_PTI_19_0_1 = 'pti19_0_1';
    /**
     * Constant for value 'previousDisturbances'
     * @return string 'previousDisturbances'
     */
    const VALUE_PREVIOUS_DISTURBANCES = 'previousDisturbances';
    /**
     * Constant for value 'pti19_1'
     * @return string 'pti19_1'
     */
    const VALUE_PTI_19_1 = 'pti19_1';
    /**
     * Constant for value 'incident'
     * @return string 'incident'
     */
    const VALUE_INCIDENT = 'incident';
    /**
     * Constant for value 'pti19_1_Alias_1'
     * @return string 'pti19_1_Alias_1'
     */
    const VALUE_PTI_19_1_ALIAS_1 = 'pti19_1_Alias_1';
    /**
     * Constant for value 'nearMiss'
     * @return string 'nearMiss'
     */
    const VALUE_NEAR_MISS = 'nearMiss';
    /**
     * Constant for value 'pti19_1_Alias_2'
     * @return string 'pti19_1_Alias_2'
     */
    const VALUE_PTI_19_1_ALIAS_2 = 'pti19_1_Alias_2';
    /**
     * Constant for value 'safetyViolation'
     * @return string 'safetyViolation'
     */
    const VALUE_SAFETY_VIOLATION = 'safetyViolation';
    /**
     * Constant for value 'pti19_1_Alias_3'
     * @return string 'pti19_1_Alias_3'
     */
    const VALUE_PTI_19_1_ALIAS_3 = 'pti19_1_Alias_3';
    /**
     * Constant for value 'signalPassedAtDanger'
     * @return string 'signalPassedAtDanger'
     */
    const VALUE_SIGNAL_PASSED_AT_DANGER = 'signalPassedAtDanger';
    /**
     * Constant for value 'pti19_1_Alias_4'
     * @return string 'pti19_1_Alias_4'
     */
    const VALUE_PTI_19_1_ALIAS_4 = 'pti19_1_Alias_4';
    /**
     * Constant for value 'stationOverrun'
     * @return string 'stationOverrun'
     */
    const VALUE_STATION_OVERRUN = 'stationOverrun';
    /**
     * Constant for value 'pti19_1_Alias_5'
     * @return string 'pti19_1_Alias_5'
     */
    const VALUE_PTI_19_1_ALIAS_5 = 'pti19_1_Alias_5';
    /**
     * Constant for value 'trainDoor'
     * @return string 'trainDoor'
     */
    const VALUE_TRAIN_DOOR = 'trainDoor';
    /**
     * Constant for value 'pti19_1_Alias_6'
     * @return string 'pti19_1_Alias_6'
     */
    const VALUE_PTI_19_1_ALIAS_6 = 'pti19_1_Alias_6';
    /**
     * Constant for value 'emergencyServicesCall'
     * @return string 'emergencyServicesCall'
     */
    const VALUE_EMERGENCY_SERVICES_CALL = 'emergencyServicesCall';
    /**
     * Constant for value 'pti19_2'
     * @return string 'pti19_2'
     */
    const VALUE_PTI_19_2 = 'pti19_2';
    /**
     * Constant for value 'bombExplosion'
     * @return string 'bombExplosion'
     */
    const VALUE_BOMB_EXPLOSION = 'bombExplosion';
    /**
     * Constant for value 'pti19_3'
     * @return string 'pti19_3'
     */
    const VALUE_PTI_19_3 = 'pti19_3';
    /**
     * Constant for value 'securityAlert'
     * @return string 'securityAlert'
     */
    const VALUE_SECURITY_ALERT = 'securityAlert';
    /**
     * Constant for value 'pti19_3_Alias_1'
     * @return string 'pti19_3_Alias_1'
     */
    const VALUE_PTI_19_3_ALIAS_1 = 'pti19_3_Alias_1';
    /**
     * Constant for value 'policeRequest'
     * @return string 'policeRequest'
     */
    const VALUE_POLICE_REQUEST = 'policeRequest';
    /**
     * Constant for value 'pti19_3_Alias_2'
     * @return string 'pti19_3_Alias_2'
     */
    const VALUE_PTI_19_3_ALIAS_2 = 'pti19_3_Alias_2';
    /**
     * Constant for value 'fireBrigadeSafetyChecks'
     * @return string 'fireBrigadeSafetyChecks'
     */
    const VALUE_FIRE_BRIGADE_SAFETY_CHECKS = 'fireBrigadeSafetyChecks';
    /**
     * Constant for value 'pti19_3_Alias_3'
     * @return string 'pti19_3_Alias_3'
     */
    const VALUE_PTI_19_3_ALIAS_3 = 'pti19_3_Alias_3';
    /**
     * Constant for value 'unattendedBag'
     * @return string 'unattendedBag'
     */
    const VALUE_UNATTENDED_BAG = 'unattendedBag';
    /**
     * Constant for value 'pti19_3_Alias_4'
     * @return string 'pti19_3_Alias_4'
     */
    const VALUE_PTI_19_3_ALIAS_4 = 'pti19_3_Alias_4';
    /**
     * Constant for value 'telephonedThreat'
     * @return string 'telephonedThreat'
     */
    const VALUE_TELEPHONED_THREAT = 'telephonedThreat';
    /**
     * Constant for value 'pti19_3_Alias_5'
     * @return string 'pti19_3_Alias_5'
     */
    const VALUE_PTI_19_3_ALIAS_5 = 'pti19_3_Alias_5';
    /**
     * Constant for value 'suspectVehicle'
     * @return string 'suspectVehicle'
     */
    const VALUE_SUSPECT_VEHICLE = 'suspectVehicle';
    /**
     * Constant for value 'pti19_3_Alias_6'
     * @return string 'pti19_3_Alias_6'
     */
    const VALUE_PTI_19_3_ALIAS_6 = 'pti19_3_Alias_6';
    /**
     * Constant for value 'civilEmergency'
     * @return string 'civilEmergency'
     */
    const VALUE_CIVIL_EMERGENCY = 'civilEmergency';
    /**
     * Constant for value 'pti19_3_Alias_7'
     * @return string 'pti19_3_Alias_7'
     */
    const VALUE_PTI_19_3_ALIAS_7 = 'pti19_3_Alias_7';
    /**
     * Constant for value 'airRaid'
     * @return string 'airRaid'
     */
    const VALUE_AIR_RAID = 'airRaid';
    /**
     * Constant for value 'pti19_3_Alias_8'
     * @return string 'pti19_3_Alias_8'
     */
    const VALUE_PTI_19_3_ALIAS_8 = 'pti19_3_Alias_8';
    /**
     * Constant for value 'sabotage'
     * @return string 'sabotage'
     */
    const VALUE_SABOTAGE = 'sabotage';
    /**
     * Constant for value 'pti19_3_Alias_9'
     * @return string 'pti19_3_Alias_9'
     */
    const VALUE_PTI_19_3_ALIAS_9 = 'pti19_3_Alias_9';
    /**
     * Constant for value 'bombAlert'
     * @return string 'bombAlert'
     */
    const VALUE_BOMB_ALERT = 'bombAlert';
    /**
     * Constant for value 'pti19_3_Alias_10'
     * @return string 'pti19_3_Alias_10'
     */
    const VALUE_PTI_19_3_ALIAS_10 = 'pti19_3_Alias_10';
    /**
     * Constant for value 'attack'
     * @return string 'attack'
     */
    const VALUE_ATTACK = 'attack';
    /**
     * Constant for value 'pti19_3_Alias_11'
     * @return string 'pti19_3_Alias_11'
     */
    const VALUE_PTI_19_3_ALIAS_11 = 'pti19_3_Alias_11';
    /**
     * Constant for value 'evacuation'
     * @return string 'evacuation'
     */
    const VALUE_EVACUATION = 'evacuation';
    /**
     * Constant for value 'pti19_3_Alias_12'
     * @return string 'pti19_3_Alias_12'
     */
    const VALUE_PTI_19_3_ALIAS_12 = 'pti19_3_Alias_12';
    /**
     * Constant for value 'terroristIncident'
     * @return string 'terroristIncident'
     */
    const VALUE_TERRORIST_INCIDENT = 'terroristIncident';
    /**
     * Constant for value 'pti19_3_Alias_13'
     * @return string 'pti19_3_Alias_13'
     */
    const VALUE_PTI_19_3_ALIAS_13 = 'pti19_3_Alias_13';
    /**
     * Constant for value 'gunfireOnRoadway'
     * @return string 'gunfireOnRoadway'
     */
    const VALUE_GUNFIRE_ON_ROADWAY = 'gunfireOnRoadway';
    /**
     * Constant for value 'pti19_3_Alias_14'
     * @return string 'pti19_3_Alias_14'
     */
    const VALUE_PTI_19_3_ALIAS_14 = 'pti19_3_Alias_14';
    /**
     * Constant for value 'explosion'
     * @return string 'explosion'
     */
    const VALUE_EXPLOSION = 'explosion';
    /**
     * Constant for value 'pti19_3_Alias_15'
     * @return string 'pti19_3_Alias_15'
     */
    const VALUE_PTI_19_3_ALIAS_15 = 'pti19_3_Alias_15';
    /**
     * Constant for value 'explosionHazard'
     * @return string 'explosionHazard'
     */
    const VALUE_EXPLOSION_HAZARD = 'explosionHazard';
    /**
     * Constant for value 'pti19_3_Alias_16'
     * @return string 'pti19_3_Alias_16'
     */
    const VALUE_PTI_19_3_ALIAS_16 = 'pti19_3_Alias_16';
    /**
     * Constant for value 'securityIncident'
     * @return string 'securityIncident'
     */
    const VALUE_SECURITY_INCIDENT = 'securityIncident';
    /**
     * Constant for value 'pti19_3_Alias_17'
     * @return string 'pti19_3_Alias_17'
     */
    const VALUE_PTI_19_3_ALIAS_17 = 'pti19_3_Alias_17';
    /**
     * Constant for value 'fireBrigadeOrder'
     * @return string 'fireBrigadeOrder'
     */
    const VALUE_FIRE_BRIGADE_ORDER = 'fireBrigadeOrder';
    /**
     * Constant for value 'pti19_3_Alias_18'
     * @return string 'pti19_3_Alias_18'
     */
    const VALUE_PTI_19_3_ALIAS_18 = 'pti19_3_Alias_18';
    /**
     * Constant for value 'policeActivity'
     * @return string 'policeActivity'
     */
    const VALUE_POLICE_ACTIVITY = 'policeActivity';
    /**
     * Constant for value 'pti19_4'
     * @return string 'pti19_4'
     */
    const VALUE_PTI_19_4 = 'pti19_4';
    /**
     * Constant for value 'fire'
     * @return string 'fire'
     */
    const VALUE_FIRE = 'fire';
    /**
     * Constant for value 'pti19_4_Alias_1'
     * @return string 'pti19_4_Alias_1'
     */
    const VALUE_PTI_19_4_ALIAS_1 = 'pti19_4_Alias_1';
    /**
     * Constant for value 'linesideFire'
     * @return string 'linesideFire'
     */
    const VALUE_LINESIDE_FIRE = 'linesideFire';
    /**
     * Constant for value 'pti19_5'
     * @return string 'pti19_5'
     */
    const VALUE_PTI_19_5 = 'pti19_5';
    /**
     * Constant for value 'vandalism'
     * @return string 'vandalism'
     */
    const VALUE_VANDALISM = 'vandalism';
    /**
     * Constant for value 'pti19_5_Alias_1'
     * @return string 'pti19_5_Alias_1'
     */
    const VALUE_PTI_19_5_ALIAS_1 = 'pti19_5_Alias_1';
    /**
     * Constant for value 'passengerAction'
     * @return string 'passengerAction'
     */
    const VALUE_PASSENGER_ACTION = 'passengerAction';
    /**
     * Constant for value 'pti19_5_Alias_2'
     * @return string 'pti19_5_Alias_2'
     */
    const VALUE_PTI_19_5_ALIAS_2 = 'pti19_5_Alias_2';
    /**
     * Constant for value 'staffAssault'
     * @return string 'staffAssault'
     */
    const VALUE_STAFF_ASSAULT = 'staffAssault';
    /**
     * Constant for value 'pti19_5_Alias_3'
     * @return string 'pti19_5_Alias_3'
     */
    const VALUE_PTI_19_5_ALIAS_3 = 'pti19_5_Alias_3';
    /**
     * Constant for value 'railwayCrime'
     * @return string 'railwayCrime'
     */
    const VALUE_RAILWAY_CRIME = 'railwayCrime';
    /**
     * Constant for value 'pti19_5_Alias_4'
     * @return string 'pti19_5_Alias_4'
     */
    const VALUE_PTI_19_5_ALIAS_4 = 'pti19_5_Alias_4';
    /**
     * Constant for value 'assault'
     * @return string 'assault'
     */
    const VALUE_ASSAULT = 'assault';
    /**
     * Constant for value 'pti19_5_Alias_5'
     * @return string 'pti19_5_Alias_5'
     */
    const VALUE_PTI_19_5_ALIAS_5 = 'pti19_5_Alias_5';
    /**
     * Constant for value 'theft'
     * @return string 'theft'
     */
    const VALUE_THEFT = 'theft';
    /**
     * Constant for value 'altercation '
     * @return string 'altercation '
     */
    const VALUE_ALTERCATION = 'altercation ';
    /**
     * Constant for value 'pti19_1_Alias_7'
     * @return string 'pti19_1_Alias_7'
     */
    const VALUE_PTI_19_1_ALIAS_7 = 'pti19_1_Alias_7';
    /**
     * Constant for value 'illVehicleOccupants '
     * @return string 'illVehicleOccupants '
     */
    const VALUE_ILL_VEHICLE_OCCUPANTS = 'illVehicleOccupants ';
    /**
     * Constant for value 'pti19_6'
     * @return string 'pti19_6'
     */
    const VALUE_PTI_19_6 = 'pti19_6';
    /**
     * Constant for value 'accident'
     * @return string 'accident'
     */
    const VALUE_ACCIDENT = 'accident';
    /**
     * Constant for value 'pti19_6_Alias_1'
     * @return string 'pti19_6_Alias_1'
     */
    const VALUE_PTI_19_6_ALIAS_1 = 'pti19_6_Alias_1';
    /**
     * Constant for value 'fatality'
     * @return string 'fatality'
     */
    const VALUE_FATALITY = 'fatality';
    /**
     * Constant for value 'pti19_6_Alias_2'
     * @return string 'pti19_6_Alias_2'
     */
    const VALUE_PTI_19_6_ALIAS_2 = 'pti19_6_Alias_2';
    /**
     * Constant for value 'personUnderTrain'
     * @return string 'personUnderTrain'
     */
    const VALUE_PERSON_UNDER_TRAIN = 'personUnderTrain';
    /**
     * Constant for value 'pti19_6_Alias_3'
     * @return string 'pti19_6_Alias_3'
     */
    const VALUE_PTI_19_6_ALIAS_3 = 'pti19_6_Alias_3';
    /**
     * Constant for value 'personHitByTrain'
     * @return string 'personHitByTrain'
     */
    const VALUE_PERSON_HIT_BY_TRAIN = 'personHitByTrain';
    /**
     * Constant for value 'pti19_6_Alias_4'
     * @return string 'pti19_6_Alias_4'
     */
    const VALUE_PTI_19_6_ALIAS_4 = 'pti19_6_Alias_4';
    /**
     * Constant for value 'personIllOnVehicle'
     * @return string 'personIllOnVehicle'
     */
    const VALUE_PERSON_ILL_ON_VEHICLE = 'personIllOnVehicle';
    /**
     * Constant for value 'pti19_6_Alias_5'
     * @return string 'pti19_6_Alias_5'
     */
    const VALUE_PTI_19_6_ALIAS_5 = 'pti19_6_Alias_5';
    /**
     * Constant for value 'emergencyServices'
     * @return string 'emergencyServices'
     */
    const VALUE_EMERGENCY_SERVICES = 'emergencyServices';
    /**
     * Constant for value 'pti19_6_Alias_6'
     * @return string 'pti19_6_Alias_6'
     */
    const VALUE_PTI_19_6_ALIAS_6 = 'pti19_6_Alias_6';
    /**
     * Constant for value 'collision'
     * @return string 'collision'
     */
    const VALUE_COLLISION = 'collision';
    /**
     * Constant for value 'pti19_7'
     * @return string 'pti19_7'
     */
    const VALUE_PTI_19_7 = 'pti19_7';
    /**
     * Constant for value 'overcrowded'
     * @return string 'overcrowded'
     */
    const VALUE_OVERCROWDED = 'overcrowded';
    /**
     * Constant for value 'pti19_8'
     * @return string 'pti19_8'
     */
    const VALUE_PTI_19_8 = 'pti19_8';
    /**
     * Constant for value 'insufficientDemand'
     * @return string 'insufficientDemand'
     */
    const VALUE_INSUFFICIENT_DEMAND = 'insufficientDemand';
    /**
     * Constant for value 'pti19_9'
     * @return string 'pti19_9'
     */
    const VALUE_PTI_19_9 = 'pti19_9';
    /**
     * Constant for value 'lightingFailure'
     * @return string 'lightingFailure'
     */
    const VALUE_LIGHTING_FAILURE = 'lightingFailure';
    /**
     * Constant for value 'pti19_10'
     * @return string 'pti19_10'
     */
    const VALUE_PTI_19_10 = 'pti19_10';
    /**
     * Constant for value 'leaderBoardFailure'
     * @return string 'leaderBoardFailure'
     */
    const VALUE_LEADER_BOARD_FAILURE = 'leaderBoardFailure';
    /**
     * Constant for value 'pti19_11'
     * @return string 'pti19_11'
     */
    const VALUE_PTI_19_11 = 'pti19_11';
    /**
     * Constant for value 'serviceIndicatorFailure'
     * @return string 'serviceIndicatorFailure'
     */
    const VALUE_SERVICE_INDICATOR_FAILURE = 'serviceIndicatorFailure';
    /**
     * Constant for value 'pti19_12'
     * @return string 'pti19_12'
     */
    const VALUE_PTI_19_12 = 'pti19_12';
    /**
     * Constant for value 'serviceFailure'
     * @return string 'serviceFailure'
     */
    const VALUE_SERVICE_FAILURE = 'serviceFailure';
    /**
     * Constant for value 'pti19_13'
     * @return string 'pti19_13'
     */
    const VALUE_PTI_19_13 = 'pti19_13';
    /**
     * Constant for value 'operatorCeasedTrading'
     * @return string 'operatorCeasedTrading'
     */
    const VALUE_OPERATOR_CEASED_TRADING = 'operatorCeasedTrading';
    /**
     * Constant for value 'pti19_14'
     * @return string 'pti19_14'
     */
    const VALUE_PTI_19_14 = 'pti19_14';
    /**
     * Constant for value 'operatorSuspended'
     * @return string 'operatorSuspended'
     */
    const VALUE_OPERATOR_SUSPENDED = 'operatorSuspended';
    /**
     * Constant for value 'pti19_15'
     * @return string 'pti19_15'
     */
    const VALUE_PTI_19_15 = 'pti19_15';
    /**
     * Constant for value 'congestion'
     * @return string 'congestion'
     */
    const VALUE_CONGESTION = 'congestion';
    /**
     * Constant for value 'pti19_16'
     * @return string 'pti19_16'
     */
    const VALUE_PTI_19_16 = 'pti19_16';
    /**
     * Constant for value 'routeBlockage'
     * @return string 'routeBlockage'
     */
    const VALUE_ROUTE_BLOCKAGE = 'routeBlockage';
    /**
     * Constant for value 'pti19_17'
     * @return string 'pti19_17'
     */
    const VALUE_PTI_19_17 = 'pti19_17';
    /**
     * Constant for value 'personOnTheLine'
     * @return string 'personOnTheLine'
     */
    const VALUE_PERSON_ON_THE_LINE = 'personOnTheLine';
    /**
     * Constant for value 'pti19_18'
     * @return string 'pti19_18'
     */
    const VALUE_PTI_19_18 = 'pti19_18';
    /**
     * Constant for value 'vehicleOnTheLine'
     * @return string 'vehicleOnTheLine'
     */
    const VALUE_VEHICLE_ON_THE_LINE = 'vehicleOnTheLine';
    /**
     * Constant for value 'pti19_18_Alias_1'
     * @return string 'pti19_18_Alias_1'
     */
    const VALUE_PTI_19_18_ALIAS_1 = 'pti19_18_Alias_1';
    /**
     * Constant for value 'levelCrossingIncident'
     * @return string 'levelCrossingIncident'
     */
    const VALUE_LEVEL_CROSSING_INCIDENT = 'levelCrossingIncident';
    /**
     * Constant for value 'pti19_19'
     * @return string 'pti19_19'
     */
    const VALUE_PTI_19_19 = 'pti19_19';
    /**
     * Constant for value 'objectOnTheLine'
     * @return string 'objectOnTheLine'
     */
    const VALUE_OBJECT_ON_THE_LINE = 'objectOnTheLine';
    /**
     * Constant for value 'pti19_19_Alias_1'
     * @return string 'pti19_19_Alias_1'
     */
    const VALUE_PTI_19_19_ALIAS_1 = 'pti19_19_Alias_1';
    /**
     * Constant for value 'fallenTreeOnTheLine'
     * @return string 'fallenTreeOnTheLine'
     */
    const VALUE_FALLEN_TREE_ON_THE_LINE = 'fallenTreeOnTheLine';
    /**
     * Constant for value 'pti19_19_Alias_2'
     * @return string 'pti19_19_Alias_2'
     */
    const VALUE_PTI_19_19_ALIAS_2 = 'pti19_19_Alias_2';
    /**
     * Constant for value 'vegetation'
     * @return string 'vegetation'
     */
    const VALUE_VEGETATION = 'vegetation';
    /**
     * Constant for value 'pti19_19_Alias_3'
     * @return string 'pti19_19_Alias_3'
     */
    const VALUE_PTI_19_19_ALIAS_3 = 'pti19_19_Alias_3';
    /**
     * Constant for value 'trainStruckAnimal'
     * @return string 'trainStruckAnimal'
     */
    const VALUE_TRAIN_STRUCK_ANIMAL = 'trainStruckAnimal';
    /**
     * Constant for value 'pti19_19_Alias_4'
     * @return string 'pti19_19_Alias_4'
     */
    const VALUE_PTI_19_19_ALIAS_4 = 'pti19_19_Alias_4';
    /**
     * Constant for value 'trainStruckObject'
     * @return string 'trainStruckObject'
     */
    const VALUE_TRAIN_STRUCK_OBJECT = 'trainStruckObject';
    /**
     * Constant for value 'pti19_20'
     * @return string 'pti19_20'
     */
    const VALUE_PTI_19_20 = 'pti19_20';
    /**
     * Constant for value 'animalOnTheLine'
     * @return string 'animalOnTheLine'
     */
    const VALUE_ANIMAL_ON_THE_LINE = 'animalOnTheLine';
    /**
     * Constant for value 'pti19_21'
     * @return string 'pti19_21'
     */
    const VALUE_PTI_19_21 = 'pti19_21';
    /**
     * Constant for value 'routeDiversion'
     * @return string 'routeDiversion'
     */
    const VALUE_ROUTE_DIVERSION = 'routeDiversion';
    /**
     * Constant for value 'pti19_22'
     * @return string 'pti19_22'
     */
    const VALUE_PTI_19_22 = 'pti19_22';
    /**
     * Constant for value 'roadClosed'
     * @return string 'roadClosed'
     */
    const VALUE_ROAD_CLOSED = 'roadClosed';
    /**
     * Constant for value 'pti19_23'
     * @return string 'pti19_23'
     */
    const VALUE_PTI_19_23 = 'pti19_23';
    /**
     * Constant for value 'roadworks'
     * @return string 'roadworks'
     */
    const VALUE_ROADWORKS = 'roadworks';
    /**
     * Constant for value 'pti19_23_Alias_1'
     * @return string 'pti19_23_Alias_1'
     */
    const VALUE_PTI_19_23_ALIAS_1 = 'pti19_23_Alias_1';
    /**
     * Constant for value 'sewerageMaintenance'
     * @return string 'sewerageMaintenance'
     */
    const VALUE_SEWERAGE_MAINTENANCE = 'sewerageMaintenance';
    /**
     * Constant for value 'pti19_23_Alias_2'
     * @return string 'pti19_23_Alias_2'
     */
    const VALUE_PTI_19_23_ALIAS_2 = 'pti19_23_Alias_2';
    /**
     * Constant for value 'roadMaintenance'
     * @return string 'roadMaintenance'
     */
    const VALUE_ROAD_MAINTENANCE = 'roadMaintenance';
    /**
     * Constant for value 'pti19_23_Alias_3'
     * @return string 'pti19_23_Alias_3'
     */
    const VALUE_PTI_19_23_ALIAS_3 = 'pti19_23_Alias_3';
    /**
     * Constant for value 'asphalting'
     * @return string 'asphalting'
     */
    const VALUE_ASPHALTING = 'asphalting';
    /**
     * Constant for value 'pti19_23_Alias_4'
     * @return string 'pti19_23_Alias_4'
     */
    const VALUE_PTI_19_23_ALIAS_4 = 'pti19_23_Alias_4';
    /**
     * Constant for value 'paving'
     * @return string 'paving'
     */
    const VALUE_PAVING = 'paving';
    /**
     * Constant for value 'pti19_24'
     * @return string 'pti19_24'
     */
    const VALUE_PTI_19_24 = 'pti19_24';
    /**
     * Constant for value 'specialEvent'
     * @return string 'specialEvent'
     */
    const VALUE_SPECIAL_EVENT = 'specialEvent';
    /**
     * Constant for value 'pti19_24_Alias_1'
     * @return string 'pti19_24_Alias_1'
     */
    const VALUE_PTI_19_24_ALIAS_1 = 'pti19_24_Alias_1';
    /**
     * Constant for value 'march'
     * @return string 'march'
     */
    const VALUE_MARCH = 'march';
    /**
     * Constant for value 'pti19_24_Alias_2'
     * @return string 'pti19_24_Alias_2'
     */
    const VALUE_PTI_19_24_ALIAS_2 = 'pti19_24_Alias_2';
    /**
     * Constant for value 'procession'
     * @return string 'procession'
     */
    const VALUE_PROCESSION = 'procession';
    /**
     * Constant for value 'pti19_24_Alias_3'
     * @return string 'pti19_24_Alias_3'
     */
    const VALUE_PTI_19_24_ALIAS_3 = 'pti19_24_Alias_3';
    /**
     * Constant for value 'demonstration'
     * @return string 'demonstration'
     */
    const VALUE_DEMONSTRATION = 'demonstration';
    /**
     * Constant for value 'pti19_24_Alias_4'
     * @return string 'pti19_24_Alias_4'
     */
    const VALUE_PTI_19_24_ALIAS_4 = 'pti19_24_Alias_4';
    /**
     * Constant for value 'publicDisturbance'
     * @return string 'publicDisturbance'
     */
    const VALUE_PUBLIC_DISTURBANCE = 'publicDisturbance';
    /**
     * Constant for value 'pti19_24_Alias_5'
     * @return string 'pti19_24_Alias_5'
     */
    const VALUE_PTI_19_24_ALIAS_5 = 'pti19_24_Alias_5';
    /**
     * Constant for value 'filterBlockade'
     * @return string 'filterBlockade'
     */
    const VALUE_FILTER_BLOCKADE = 'filterBlockade';
    /**
     * Constant for value 'pti19_24_Alias_6'
     * @return string 'pti19_24_Alias_6'
     */
    const VALUE_PTI_19_24_ALIAS_6 = 'pti19_24_Alias_6';
    /**
     * Constant for value 'sightseersObstructingAccess'
     * @return string 'sightseersObstructingAccess'
     */
    const VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS = 'sightseersObstructingAccess';
    /**
     * Constant for value 'pti19_24_Alias_7'
     * @return string 'pti19_24_Alias_7'
     */
    const VALUE_PTI_19_24_ALIAS_7 = 'pti19_24_Alias_7';
    /**
     * Constant for value 'holiday'
     * @return string 'holiday'
     */
    const VALUE_HOLIDAY = 'holiday';
    /**
     * Constant for value 'pti19_25'
     * @return string 'pti19_25'
     */
    const VALUE_PTI_19_25 = 'pti19_25';
    /**
     * Constant for value 'bridgeStrike'
     * @return string 'bridgeStrike'
     */
    const VALUE_BRIDGE_STRIKE = 'bridgeStrike';
    /**
     * Constant for value 'pti19_25_Alias_1'
     * @return string 'pti19_25_Alias_1'
     */
    const VALUE_PTI_19_25_ALIAS_1 = 'pti19_25_Alias_1';
    /**
     * Constant for value 'viaductFailure'
     * @return string 'viaductFailure'
     */
    const VALUE_VIADUCT_FAILURE = 'viaductFailure';
    /**
     * Constant for value 'pti19_26'
     * @return string 'pti19_26'
     */
    const VALUE_PTI_19_26 = 'pti19_26';
    /**
     * Constant for value 'overheadObstruction'
     * @return string 'overheadObstruction'
     */
    const VALUE_OVERHEAD_OBSTRUCTION = 'overheadObstruction';
    /**
     * Constant for value 'pti19_27'
     * @return string 'pti19_27'
     */
    const VALUE_PTI_19_27 = 'pti19_27';
    /**
     * Constant for value 'undefinedProblem'
     * @return string 'undefinedProblem'
     */
    const VALUE_UNDEFINED_PROBLEM = 'undefinedProblem';
    /**
     * Constant for value 'pti19_15_Alias_1'
     * @return string 'pti19_15_Alias_1'
     */
    const VALUE_PTI_19_15_ALIAS_1 = 'pti19_15_Alias_1';
    /**
     * Constant for value 'problemsAtBorderPost'
     * @return string 'problemsAtBorderPost'
     */
    const VALUE_PROBLEMS_AT_BORDER_POST = 'problemsAtBorderPost';
    /**
     * Constant for value 'pti19_15_Alias_2'
     * @return string 'pti19_15_Alias_2'
     */
    const VALUE_PTI_19_15_ALIAS_2 = 'pti19_15_Alias_2';
    /**
     * Constant for value 'problemsAtCustomsPost'
     * @return string 'problemsAtCustomsPost'
     */
    const VALUE_PROBLEMS_AT_CUSTOMS_POST = 'problemsAtCustomsPost';
    /**
     * Constant for value 'pti19_15_Alias_3'
     * @return string 'pti19_15_Alias_3'
     */
    const VALUE_PTI_19_15_ALIAS_3 = 'pti19_15_Alias_3';
    /**
     * Constant for value 'speedRestrictions'
     * @return string 'speedRestrictions'
     */
    const VALUE_SPEED_RESTRICTIONS = 'speedRestrictions';
    /**
     * Constant for value 'pti19_255_Alias_1'
     * @return string 'pti19_255_Alias_1'
     */
    const VALUE_PTI_19_255_ALIAS_1 = 'pti19_255_Alias_1';
    /**
     * Constant for value 'logisticProblems'
     * @return string 'logisticProblems'
     */
    const VALUE_LOGISTIC_PROBLEMS = 'logisticProblems';
    /**
     * Constant for value 'pti19_255_Alias_2'
     * @return string 'pti19_255_Alias_2'
     */
    const VALUE_PTI_19_255_ALIAS_2 = 'pti19_255_Alias_2';
    /**
     * Constant for value 'problemsOnLocalRoad'
     * @return string 'problemsOnLocalRoad'
     */
    const VALUE_PROBLEMS_ON_LOCAL_ROAD = 'problemsOnLocalRoad';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_19_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_19_0_1
     * @uses self::VALUE_PREVIOUS_DISTURBANCES
     * @uses self::VALUE_PTI_19_1
     * @uses self::VALUE_INCIDENT
     * @uses self::VALUE_PTI_19_1_ALIAS_1
     * @uses self::VALUE_NEAR_MISS
     * @uses self::VALUE_PTI_19_1_ALIAS_2
     * @uses self::VALUE_SAFETY_VIOLATION
     * @uses self::VALUE_PTI_19_1_ALIAS_3
     * @uses self::VALUE_SIGNAL_PASSED_AT_DANGER
     * @uses self::VALUE_PTI_19_1_ALIAS_4
     * @uses self::VALUE_STATION_OVERRUN
     * @uses self::VALUE_PTI_19_1_ALIAS_5
     * @uses self::VALUE_TRAIN_DOOR
     * @uses self::VALUE_PTI_19_1_ALIAS_6
     * @uses self::VALUE_EMERGENCY_SERVICES_CALL
     * @uses self::VALUE_PTI_19_2
     * @uses self::VALUE_BOMB_EXPLOSION
     * @uses self::VALUE_PTI_19_3
     * @uses self::VALUE_SECURITY_ALERT
     * @uses self::VALUE_PTI_19_3_ALIAS_1
     * @uses self::VALUE_POLICE_REQUEST
     * @uses self::VALUE_PTI_19_3_ALIAS_2
     * @uses self::VALUE_FIRE_BRIGADE_SAFETY_CHECKS
     * @uses self::VALUE_PTI_19_3_ALIAS_3
     * @uses self::VALUE_UNATTENDED_BAG
     * @uses self::VALUE_PTI_19_3_ALIAS_4
     * @uses self::VALUE_TELEPHONED_THREAT
     * @uses self::VALUE_PTI_19_3_ALIAS_5
     * @uses self::VALUE_SUSPECT_VEHICLE
     * @uses self::VALUE_PTI_19_3_ALIAS_6
     * @uses self::VALUE_CIVIL_EMERGENCY
     * @uses self::VALUE_PTI_19_3_ALIAS_7
     * @uses self::VALUE_AIR_RAID
     * @uses self::VALUE_PTI_19_3_ALIAS_8
     * @uses self::VALUE_SABOTAGE
     * @uses self::VALUE_PTI_19_3_ALIAS_9
     * @uses self::VALUE_BOMB_ALERT
     * @uses self::VALUE_PTI_19_3_ALIAS_10
     * @uses self::VALUE_ATTACK
     * @uses self::VALUE_PTI_19_3_ALIAS_11
     * @uses self::VALUE_EVACUATION
     * @uses self::VALUE_PTI_19_3_ALIAS_12
     * @uses self::VALUE_TERRORIST_INCIDENT
     * @uses self::VALUE_PTI_19_3_ALIAS_13
     * @uses self::VALUE_GUNFIRE_ON_ROADWAY
     * @uses self::VALUE_PTI_19_3_ALIAS_14
     * @uses self::VALUE_EXPLOSION
     * @uses self::VALUE_PTI_19_3_ALIAS_15
     * @uses self::VALUE_EXPLOSION_HAZARD
     * @uses self::VALUE_PTI_19_3_ALIAS_16
     * @uses self::VALUE_SECURITY_INCIDENT
     * @uses self::VALUE_PTI_19_3_ALIAS_17
     * @uses self::VALUE_FIRE_BRIGADE_ORDER
     * @uses self::VALUE_PTI_19_3_ALIAS_18
     * @uses self::VALUE_POLICE_ACTIVITY
     * @uses self::VALUE_PTI_19_4
     * @uses self::VALUE_FIRE
     * @uses self::VALUE_PTI_19_4_ALIAS_1
     * @uses self::VALUE_LINESIDE_FIRE
     * @uses self::VALUE_PTI_19_5
     * @uses self::VALUE_VANDALISM
     * @uses self::VALUE_PTI_19_5_ALIAS_1
     * @uses self::VALUE_PASSENGER_ACTION
     * @uses self::VALUE_PTI_19_5_ALIAS_2
     * @uses self::VALUE_STAFF_ASSAULT
     * @uses self::VALUE_PTI_19_5_ALIAS_3
     * @uses self::VALUE_RAILWAY_CRIME
     * @uses self::VALUE_PTI_19_5_ALIAS_4
     * @uses self::VALUE_ASSAULT
     * @uses self::VALUE_PTI_19_5_ALIAS_5
     * @uses self::VALUE_THEFT
     * @uses self::VALUE_ALTERCATION
     * @uses self::VALUE_PTI_19_1_ALIAS_7
     * @uses self::VALUE_ILL_VEHICLE_OCCUPANTS
     * @uses self::VALUE_PTI_19_6
     * @uses self::VALUE_ACCIDENT
     * @uses self::VALUE_PTI_19_6_ALIAS_1
     * @uses self::VALUE_FATALITY
     * @uses self::VALUE_PTI_19_6_ALIAS_2
     * @uses self::VALUE_PERSON_UNDER_TRAIN
     * @uses self::VALUE_PTI_19_6_ALIAS_3
     * @uses self::VALUE_PERSON_HIT_BY_TRAIN
     * @uses self::VALUE_PTI_19_6_ALIAS_4
     * @uses self::VALUE_PERSON_ILL_ON_VEHICLE
     * @uses self::VALUE_PTI_19_6_ALIAS_5
     * @uses self::VALUE_EMERGENCY_SERVICES
     * @uses self::VALUE_PTI_19_6_ALIAS_6
     * @uses self::VALUE_COLLISION
     * @uses self::VALUE_PTI_19_7
     * @uses self::VALUE_OVERCROWDED
     * @uses self::VALUE_PTI_19_8
     * @uses self::VALUE_INSUFFICIENT_DEMAND
     * @uses self::VALUE_PTI_19_9
     * @uses self::VALUE_LIGHTING_FAILURE
     * @uses self::VALUE_PTI_19_10
     * @uses self::VALUE_LEADER_BOARD_FAILURE
     * @uses self::VALUE_PTI_19_11
     * @uses self::VALUE_SERVICE_INDICATOR_FAILURE
     * @uses self::VALUE_PTI_19_12
     * @uses self::VALUE_SERVICE_FAILURE
     * @uses self::VALUE_PTI_19_13
     * @uses self::VALUE_OPERATOR_CEASED_TRADING
     * @uses self::VALUE_PTI_19_14
     * @uses self::VALUE_OPERATOR_SUSPENDED
     * @uses self::VALUE_PTI_19_15
     * @uses self::VALUE_CONGESTION
     * @uses self::VALUE_PTI_19_16
     * @uses self::VALUE_ROUTE_BLOCKAGE
     * @uses self::VALUE_PTI_19_17
     * @uses self::VALUE_PERSON_ON_THE_LINE
     * @uses self::VALUE_PTI_19_18
     * @uses self::VALUE_VEHICLE_ON_THE_LINE
     * @uses self::VALUE_PTI_19_18_ALIAS_1
     * @uses self::VALUE_LEVEL_CROSSING_INCIDENT
     * @uses self::VALUE_PTI_19_19
     * @uses self::VALUE_OBJECT_ON_THE_LINE
     * @uses self::VALUE_PTI_19_19_ALIAS_1
     * @uses self::VALUE_FALLEN_TREE_ON_THE_LINE
     * @uses self::VALUE_PTI_19_19_ALIAS_2
     * @uses self::VALUE_VEGETATION
     * @uses self::VALUE_PTI_19_19_ALIAS_3
     * @uses self::VALUE_TRAIN_STRUCK_ANIMAL
     * @uses self::VALUE_PTI_19_19_ALIAS_4
     * @uses self::VALUE_TRAIN_STRUCK_OBJECT
     * @uses self::VALUE_PTI_19_20
     * @uses self::VALUE_ANIMAL_ON_THE_LINE
     * @uses self::VALUE_PTI_19_21
     * @uses self::VALUE_ROUTE_DIVERSION
     * @uses self::VALUE_PTI_19_22
     * @uses self::VALUE_ROAD_CLOSED
     * @uses self::VALUE_PTI_19_23
     * @uses self::VALUE_ROADWORKS
     * @uses self::VALUE_PTI_19_23_ALIAS_1
     * @uses self::VALUE_SEWERAGE_MAINTENANCE
     * @uses self::VALUE_PTI_19_23_ALIAS_2
     * @uses self::VALUE_ROAD_MAINTENANCE
     * @uses self::VALUE_PTI_19_23_ALIAS_3
     * @uses self::VALUE_ASPHALTING
     * @uses self::VALUE_PTI_19_23_ALIAS_4
     * @uses self::VALUE_PAVING
     * @uses self::VALUE_PTI_19_24
     * @uses self::VALUE_SPECIAL_EVENT
     * @uses self::VALUE_PTI_19_24_ALIAS_1
     * @uses self::VALUE_MARCH
     * @uses self::VALUE_PTI_19_24_ALIAS_2
     * @uses self::VALUE_PROCESSION
     * @uses self::VALUE_PTI_19_24_ALIAS_3
     * @uses self::VALUE_DEMONSTRATION
     * @uses self::VALUE_PTI_19_24_ALIAS_4
     * @uses self::VALUE_PUBLIC_DISTURBANCE
     * @uses self::VALUE_PTI_19_24_ALIAS_5
     * @uses self::VALUE_FILTER_BLOCKADE
     * @uses self::VALUE_PTI_19_24_ALIAS_6
     * @uses self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS
     * @uses self::VALUE_PTI_19_24_ALIAS_7
     * @uses self::VALUE_HOLIDAY
     * @uses self::VALUE_PTI_19_25
     * @uses self::VALUE_BRIDGE_STRIKE
     * @uses self::VALUE_PTI_19_25_ALIAS_1
     * @uses self::VALUE_VIADUCT_FAILURE
     * @uses self::VALUE_PTI_19_26
     * @uses self::VALUE_OVERHEAD_OBSTRUCTION
     * @uses self::VALUE_PTI_19_27
     * @uses self::VALUE_UNDEFINED_PROBLEM
     * @uses self::VALUE_PTI_19_15_ALIAS_1
     * @uses self::VALUE_PROBLEMS_AT_BORDER_POST
     * @uses self::VALUE_PTI_19_15_ALIAS_2
     * @uses self::VALUE_PROBLEMS_AT_CUSTOMS_POST
     * @uses self::VALUE_PTI_19_15_ALIAS_3
     * @uses self::VALUE_SPEED_RESTRICTIONS
     * @uses self::VALUE_PTI_19_255_ALIAS_1
     * @uses self::VALUE_LOGISTIC_PROBLEMS
     * @uses self::VALUE_PTI_19_255_ALIAS_2
     * @uses self::VALUE_PROBLEMS_ON_LOCAL_ROAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_19_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_19_0_1,
            self::VALUE_PREVIOUS_DISTURBANCES,
            self::VALUE_PTI_19_1,
            self::VALUE_INCIDENT,
            self::VALUE_PTI_19_1_ALIAS_1,
            self::VALUE_NEAR_MISS,
            self::VALUE_PTI_19_1_ALIAS_2,
            self::VALUE_SAFETY_VIOLATION,
            self::VALUE_PTI_19_1_ALIAS_3,
            self::VALUE_SIGNAL_PASSED_AT_DANGER,
            self::VALUE_PTI_19_1_ALIAS_4,
            self::VALUE_STATION_OVERRUN,
            self::VALUE_PTI_19_1_ALIAS_5,
            self::VALUE_TRAIN_DOOR,
            self::VALUE_PTI_19_1_ALIAS_6,
            self::VALUE_EMERGENCY_SERVICES_CALL,
            self::VALUE_PTI_19_2,
            self::VALUE_BOMB_EXPLOSION,
            self::VALUE_PTI_19_3,
            self::VALUE_SECURITY_ALERT,
            self::VALUE_PTI_19_3_ALIAS_1,
            self::VALUE_POLICE_REQUEST,
            self::VALUE_PTI_19_3_ALIAS_2,
            self::VALUE_FIRE_BRIGADE_SAFETY_CHECKS,
            self::VALUE_PTI_19_3_ALIAS_3,
            self::VALUE_UNATTENDED_BAG,
            self::VALUE_PTI_19_3_ALIAS_4,
            self::VALUE_TELEPHONED_THREAT,
            self::VALUE_PTI_19_3_ALIAS_5,
            self::VALUE_SUSPECT_VEHICLE,
            self::VALUE_PTI_19_3_ALIAS_6,
            self::VALUE_CIVIL_EMERGENCY,
            self::VALUE_PTI_19_3_ALIAS_7,
            self::VALUE_AIR_RAID,
            self::VALUE_PTI_19_3_ALIAS_8,
            self::VALUE_SABOTAGE,
            self::VALUE_PTI_19_3_ALIAS_9,
            self::VALUE_BOMB_ALERT,
            self::VALUE_PTI_19_3_ALIAS_10,
            self::VALUE_ATTACK,
            self::VALUE_PTI_19_3_ALIAS_11,
            self::VALUE_EVACUATION,
            self::VALUE_PTI_19_3_ALIAS_12,
            self::VALUE_TERRORIST_INCIDENT,
            self::VALUE_PTI_19_3_ALIAS_13,
            self::VALUE_GUNFIRE_ON_ROADWAY,
            self::VALUE_PTI_19_3_ALIAS_14,
            self::VALUE_EXPLOSION,
            self::VALUE_PTI_19_3_ALIAS_15,
            self::VALUE_EXPLOSION_HAZARD,
            self::VALUE_PTI_19_3_ALIAS_16,
            self::VALUE_SECURITY_INCIDENT,
            self::VALUE_PTI_19_3_ALIAS_17,
            self::VALUE_FIRE_BRIGADE_ORDER,
            self::VALUE_PTI_19_3_ALIAS_18,
            self::VALUE_POLICE_ACTIVITY,
            self::VALUE_PTI_19_4,
            self::VALUE_FIRE,
            self::VALUE_PTI_19_4_ALIAS_1,
            self::VALUE_LINESIDE_FIRE,
            self::VALUE_PTI_19_5,
            self::VALUE_VANDALISM,
            self::VALUE_PTI_19_5_ALIAS_1,
            self::VALUE_PASSENGER_ACTION,
            self::VALUE_PTI_19_5_ALIAS_2,
            self::VALUE_STAFF_ASSAULT,
            self::VALUE_PTI_19_5_ALIAS_3,
            self::VALUE_RAILWAY_CRIME,
            self::VALUE_PTI_19_5_ALIAS_4,
            self::VALUE_ASSAULT,
            self::VALUE_PTI_19_5_ALIAS_5,
            self::VALUE_THEFT,
            self::VALUE_ALTERCATION,
            self::VALUE_PTI_19_1_ALIAS_7,
            self::VALUE_ILL_VEHICLE_OCCUPANTS,
            self::VALUE_PTI_19_6,
            self::VALUE_ACCIDENT,
            self::VALUE_PTI_19_6_ALIAS_1,
            self::VALUE_FATALITY,
            self::VALUE_PTI_19_6_ALIAS_2,
            self::VALUE_PERSON_UNDER_TRAIN,
            self::VALUE_PTI_19_6_ALIAS_3,
            self::VALUE_PERSON_HIT_BY_TRAIN,
            self::VALUE_PTI_19_6_ALIAS_4,
            self::VALUE_PERSON_ILL_ON_VEHICLE,
            self::VALUE_PTI_19_6_ALIAS_5,
            self::VALUE_EMERGENCY_SERVICES,
            self::VALUE_PTI_19_6_ALIAS_6,
            self::VALUE_COLLISION,
            self::VALUE_PTI_19_7,
            self::VALUE_OVERCROWDED,
            self::VALUE_PTI_19_8,
            self::VALUE_INSUFFICIENT_DEMAND,
            self::VALUE_PTI_19_9,
            self::VALUE_LIGHTING_FAILURE,
            self::VALUE_PTI_19_10,
            self::VALUE_LEADER_BOARD_FAILURE,
            self::VALUE_PTI_19_11,
            self::VALUE_SERVICE_INDICATOR_FAILURE,
            self::VALUE_PTI_19_12,
            self::VALUE_SERVICE_FAILURE,
            self::VALUE_PTI_19_13,
            self::VALUE_OPERATOR_CEASED_TRADING,
            self::VALUE_PTI_19_14,
            self::VALUE_OPERATOR_SUSPENDED,
            self::VALUE_PTI_19_15,
            self::VALUE_CONGESTION,
            self::VALUE_PTI_19_16,
            self::VALUE_ROUTE_BLOCKAGE,
            self::VALUE_PTI_19_17,
            self::VALUE_PERSON_ON_THE_LINE,
            self::VALUE_PTI_19_18,
            self::VALUE_VEHICLE_ON_THE_LINE,
            self::VALUE_PTI_19_18_ALIAS_1,
            self::VALUE_LEVEL_CROSSING_INCIDENT,
            self::VALUE_PTI_19_19,
            self::VALUE_OBJECT_ON_THE_LINE,
            self::VALUE_PTI_19_19_ALIAS_1,
            self::VALUE_FALLEN_TREE_ON_THE_LINE,
            self::VALUE_PTI_19_19_ALIAS_2,
            self::VALUE_VEGETATION,
            self::VALUE_PTI_19_19_ALIAS_3,
            self::VALUE_TRAIN_STRUCK_ANIMAL,
            self::VALUE_PTI_19_19_ALIAS_4,
            self::VALUE_TRAIN_STRUCK_OBJECT,
            self::VALUE_PTI_19_20,
            self::VALUE_ANIMAL_ON_THE_LINE,
            self::VALUE_PTI_19_21,
            self::VALUE_ROUTE_DIVERSION,
            self::VALUE_PTI_19_22,
            self::VALUE_ROAD_CLOSED,
            self::VALUE_PTI_19_23,
            self::VALUE_ROADWORKS,
            self::VALUE_PTI_19_23_ALIAS_1,
            self::VALUE_SEWERAGE_MAINTENANCE,
            self::VALUE_PTI_19_23_ALIAS_2,
            self::VALUE_ROAD_MAINTENANCE,
            self::VALUE_PTI_19_23_ALIAS_3,
            self::VALUE_ASPHALTING,
            self::VALUE_PTI_19_23_ALIAS_4,
            self::VALUE_PAVING,
            self::VALUE_PTI_19_24,
            self::VALUE_SPECIAL_EVENT,
            self::VALUE_PTI_19_24_ALIAS_1,
            self::VALUE_MARCH,
            self::VALUE_PTI_19_24_ALIAS_2,
            self::VALUE_PROCESSION,
            self::VALUE_PTI_19_24_ALIAS_3,
            self::VALUE_DEMONSTRATION,
            self::VALUE_PTI_19_24_ALIAS_4,
            self::VALUE_PUBLIC_DISTURBANCE,
            self::VALUE_PTI_19_24_ALIAS_5,
            self::VALUE_FILTER_BLOCKADE,
            self::VALUE_PTI_19_24_ALIAS_6,
            self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS,
            self::VALUE_PTI_19_24_ALIAS_7,
            self::VALUE_HOLIDAY,
            self::VALUE_PTI_19_25,
            self::VALUE_BRIDGE_STRIKE,
            self::VALUE_PTI_19_25_ALIAS_1,
            self::VALUE_VIADUCT_FAILURE,
            self::VALUE_PTI_19_26,
            self::VALUE_OVERHEAD_OBSTRUCTION,
            self::VALUE_PTI_19_27,
            self::VALUE_UNDEFINED_PROBLEM,
            self::VALUE_PTI_19_15_ALIAS_1,
            self::VALUE_PROBLEMS_AT_BORDER_POST,
            self::VALUE_PTI_19_15_ALIAS_2,
            self::VALUE_PROBLEMS_AT_CUSTOMS_POST,
            self::VALUE_PTI_19_15_ALIAS_3,
            self::VALUE_SPEED_RESTRICTIONS,
            self::VALUE_PTI_19_255_ALIAS_1,
            self::VALUE_LOGISTIC_PROBLEMS,
            self::VALUE_PTI_19_255_ALIAS_2,
            self::VALUE_PROBLEMS_ON_LOCAL_ROAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
