<?php

namespace EnumType;

/**
 * This class stands for MetroSubmodesOfTransportEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Metro ModesOfTransport: TPEG pti_table_04.
 * @subpackage Enumerations
 */
class MetroSubmodesOfTransportEnumeration
{
    /**
     * Constant for value 'pti4_0'
     * @return string 'pti4_0'
     */
    const VALUE_PTI_4_0 = 'pti4_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti4_1'
     * @return string 'pti4_1'
     */
    const VALUE_PTI_4_1 = 'pti4_1';
    /**
     * Constant for value 'metro'
     * @return string 'metro'
     */
    const VALUE_METRO = 'metro';
    /**
     * Constant for value 'pti4_2'
     * @return string 'pti4_2'
     */
    const VALUE_PTI_4_2 = 'pti4_2';
    /**
     * Constant for value 'tube'
     * @return string 'tube'
     */
    const VALUE_TUBE = 'tube';
    /**
     * Constant for value 'pti4_3'
     * @return string 'pti4_3'
     */
    const VALUE_PTI_4_3 = 'pti4_3';
    /**
     * Constant for value 'urbanRailway'
     * @return string 'urbanRailway'
     */
    const VALUE_URBAN_RAILWAY = 'urbanRailway';
    /**
     * Constant for value 'pti4_4'
     * @return string 'pti4_4'
     */
    const VALUE_PTI_4_4 = 'pti4_4';
    /**
     * Constant for value 'allRailServices'
     * @return string 'allRailServices'
     */
    const VALUE_ALL_RAIL_SERVICES = 'allRailServices';
    /**
     * Constant for value 'pti4_255'
     * @return string 'pti4_255'
     */
    const VALUE_PTI_4_255 = 'pti4_255';
    /**
     * Constant for value 'undefined'
     * @return string 'undefined'
     */
    const VALUE_UNDEFINED = 'undefined';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_4_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_4_1
     * @uses self::VALUE_METRO
     * @uses self::VALUE_PTI_4_2
     * @uses self::VALUE_TUBE
     * @uses self::VALUE_PTI_4_3
     * @uses self::VALUE_URBAN_RAILWAY
     * @uses self::VALUE_PTI_4_4
     * @uses self::VALUE_ALL_RAIL_SERVICES
     * @uses self::VALUE_PTI_4_255
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_4_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_4_1,
            self::VALUE_METRO,
            self::VALUE_PTI_4_2,
            self::VALUE_TUBE,
            self::VALUE_PTI_4_3,
            self::VALUE_URBAN_RAILWAY,
            self::VALUE_PTI_4_4,
            self::VALUE_ALL_RAIL_SERVICES,
            self::VALUE_PTI_4_255,
            self::VALUE_UNDEFINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
