<?php

namespace EnumType;

/**
 * This class stands for LoadTypeEnum EnumType
 * @subpackage Enumerations
 */
class LoadTypeEnum
{
    /**
     * Constant for value 'abnormalLoad'
     * @return string 'abnormalLoad'
     */
    const VALUE_ABNORMAL_LOAD = 'abnormalLoad';
    /**
     * Constant for value 'ammunition'
     * @return string 'ammunition'
     */
    const VALUE_AMMUNITION = 'ammunition';
    /**
     * Constant for value 'chemicals'
     * @return string 'chemicals'
     */
    const VALUE_CHEMICALS = 'chemicals';
    /**
     * Constant for value 'combustibleMaterials'
     * @return string 'combustibleMaterials'
     */
    const VALUE_COMBUSTIBLE_MATERIALS = 'combustibleMaterials';
    /**
     * Constant for value 'corrosiveMaterials'
     * @return string 'corrosiveMaterials'
     */
    const VALUE_CORROSIVE_MATERIALS = 'corrosiveMaterials';
    /**
     * Constant for value 'debris'
     * @return string 'debris'
     */
    const VALUE_DEBRIS = 'debris';
    /**
     * Constant for value 'empty'
     * @return string 'empty'
     */
    const VALUE_EMPTY = 'empty';
    /**
     * Constant for value 'explosiveMaterials'
     * @return string 'explosiveMaterials'
     */
    const VALUE_EXPLOSIVE_MATERIALS = 'explosiveMaterials';
    /**
     * Constant for value 'extraHighLoad'
     * @return string 'extraHighLoad'
     */
    const VALUE_EXTRA_HIGH_LOAD = 'extraHighLoad';
    /**
     * Constant for value 'extraLongLoad'
     * @return string 'extraLongLoad'
     */
    const VALUE_EXTRA_LONG_LOAD = 'extraLongLoad';
    /**
     * Constant for value 'extraWideLoad'
     * @return string 'extraWideLoad'
     */
    const VALUE_EXTRA_WIDE_LOAD = 'extraWideLoad';
    /**
     * Constant for value 'fuel'
     * @return string 'fuel'
     */
    const VALUE_FUEL = 'fuel';
    /**
     * Constant for value 'glass'
     * @return string 'glass'
     */
    const VALUE_GLASS = 'glass';
    /**
     * Constant for value 'goods'
     * @return string 'goods'
     */
    const VALUE_GOODS = 'goods';
    /**
     * Constant for value 'hazardousMaterials'
     * @return string 'hazardousMaterials'
     */
    const VALUE_HAZARDOUS_MATERIALS = 'hazardousMaterials';
    /**
     * Constant for value 'liquid'
     * @return string 'liquid'
     */
    const VALUE_LIQUID = 'liquid';
    /**
     * Constant for value 'livestock'
     * @return string 'livestock'
     */
    const VALUE_LIVESTOCK = 'livestock';
    /**
     * Constant for value 'materials'
     * @return string 'materials'
     */
    const VALUE_MATERIALS = 'materials';
    /**
     * Constant for value 'materialsDangerousForPeople'
     * @return string 'materialsDangerousForPeople'
     */
    const VALUE_MATERIALS_DANGEROUS_FOR_PEOPLE = 'materialsDangerousForPeople';
    /**
     * Constant for value 'materialsDangerousForTheEnvironment'
     * @return string 'materialsDangerousForTheEnvironment'
     */
    const VALUE_MATERIALS_DANGEROUS_FOR_THE_ENVIRONMENT = 'materialsDangerousForTheEnvironment';
    /**
     * Constant for value 'materialsDangerousForWater'
     * @return string 'materialsDangerousForWater'
     */
    const VALUE_MATERIALS_DANGEROUS_FOR_WATER = 'materialsDangerousForWater';
    /**
     * Constant for value 'oil'
     * @return string 'oil'
     */
    const VALUE_OIL = 'oil';
    /**
     * Constant for value 'ordinary'
     * @return string 'ordinary'
     */
    const VALUE_ORDINARY = 'ordinary';
    /**
     * Constant for value 'perishableProducts'
     * @return string 'perishableProducts'
     */
    const VALUE_PERISHABLE_PRODUCTS = 'perishableProducts';
    /**
     * Constant for value 'petrol'
     * @return string 'petrol'
     */
    const VALUE_PETROL = 'petrol';
    /**
     * Constant for value 'pharmaceuticalMaterials'
     * @return string 'pharmaceuticalMaterials'
     */
    const VALUE_PHARMACEUTICAL_MATERIALS = 'pharmaceuticalMaterials';
    /**
     * Constant for value 'radioactiveMaterials'
     * @return string 'radioactiveMaterials'
     */
    const VALUE_RADIOACTIVE_MATERIALS = 'radioactiveMaterials';
    /**
     * Constant for value 'refuse'
     * @return string 'refuse'
     */
    const VALUE_REFUSE = 'refuse';
    /**
     * Constant for value 'toxicMaterials'
     * @return string 'toxicMaterials'
     */
    const VALUE_TOXIC_MATERIALS = 'toxicMaterials';
    /**
     * Constant for value 'vehicles'
     * @return string 'vehicles'
     */
    const VALUE_VEHICLES = 'vehicles';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABNORMAL_LOAD
     * @uses self::VALUE_AMMUNITION
     * @uses self::VALUE_CHEMICALS
     * @uses self::VALUE_COMBUSTIBLE_MATERIALS
     * @uses self::VALUE_CORROSIVE_MATERIALS
     * @uses self::VALUE_DEBRIS
     * @uses self::VALUE_EMPTY
     * @uses self::VALUE_EXPLOSIVE_MATERIALS
     * @uses self::VALUE_EXTRA_HIGH_LOAD
     * @uses self::VALUE_EXTRA_LONG_LOAD
     * @uses self::VALUE_EXTRA_WIDE_LOAD
     * @uses self::VALUE_FUEL
     * @uses self::VALUE_GLASS
     * @uses self::VALUE_GOODS
     * @uses self::VALUE_HAZARDOUS_MATERIALS
     * @uses self::VALUE_LIQUID
     * @uses self::VALUE_LIVESTOCK
     * @uses self::VALUE_MATERIALS
     * @uses self::VALUE_MATERIALS_DANGEROUS_FOR_PEOPLE
     * @uses self::VALUE_MATERIALS_DANGEROUS_FOR_THE_ENVIRONMENT
     * @uses self::VALUE_MATERIALS_DANGEROUS_FOR_WATER
     * @uses self::VALUE_OIL
     * @uses self::VALUE_ORDINARY
     * @uses self::VALUE_PERISHABLE_PRODUCTS
     * @uses self::VALUE_PETROL
     * @uses self::VALUE_PHARMACEUTICAL_MATERIALS
     * @uses self::VALUE_RADIOACTIVE_MATERIALS
     * @uses self::VALUE_REFUSE
     * @uses self::VALUE_TOXIC_MATERIALS
     * @uses self::VALUE_VEHICLES
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABNORMAL_LOAD,
            self::VALUE_AMMUNITION,
            self::VALUE_CHEMICALS,
            self::VALUE_COMBUSTIBLE_MATERIALS,
            self::VALUE_CORROSIVE_MATERIALS,
            self::VALUE_DEBRIS,
            self::VALUE_EMPTY,
            self::VALUE_EXPLOSIVE_MATERIALS,
            self::VALUE_EXTRA_HIGH_LOAD,
            self::VALUE_EXTRA_LONG_LOAD,
            self::VALUE_EXTRA_WIDE_LOAD,
            self::VALUE_FUEL,
            self::VALUE_GLASS,
            self::VALUE_GOODS,
            self::VALUE_HAZARDOUS_MATERIALS,
            self::VALUE_LIQUID,
            self::VALUE_LIVESTOCK,
            self::VALUE_MATERIALS,
            self::VALUE_MATERIALS_DANGEROUS_FOR_PEOPLE,
            self::VALUE_MATERIALS_DANGEROUS_FOR_THE_ENVIRONMENT,
            self::VALUE_MATERIALS_DANGEROUS_FOR_WATER,
            self::VALUE_OIL,
            self::VALUE_ORDINARY,
            self::VALUE_PERISHABLE_PRODUCTS,
            self::VALUE_PETROL,
            self::VALUE_PHARMACEUTICAL_MATERIALS,
            self::VALUE_RADIOACTIVE_MATERIALS,
            self::VALUE_REFUSE,
            self::VALUE_TOXIC_MATERIALS,
            self::VALUE_VEHICLES,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
