<?php

namespace EnumType;

/**
 * This class stands for LaneEnum EnumType
 * @subpackage Enumerations
 */
class LaneEnum
{
    /**
     * Constant for value 'allLanesCompleteCarriageway'
     * @return string 'allLanesCompleteCarriageway'
     */
    const VALUE_ALL_LANES_COMPLETE_CARRIAGEWAY = 'allLanesCompleteCarriageway';
    /**
     * Constant for value 'busLane'
     * @return string 'busLane'
     */
    const VALUE_BUS_LANE = 'busLane';
    /**
     * Constant for value 'busStop'
     * @return string 'busStop'
     */
    const VALUE_BUS_STOP = 'busStop';
    /**
     * Constant for value 'carPoolLane'
     * @return string 'carPoolLane'
     */
    const VALUE_CAR_POOL_LANE = 'carPoolLane';
    /**
     * Constant for value 'centralReservation'
     * @return string 'centralReservation'
     */
    const VALUE_CENTRAL_RESERVATION = 'centralReservation';
    /**
     * Constant for value 'crawlerLane'
     * @return string 'crawlerLane'
     */
    const VALUE_CRAWLER_LANE = 'crawlerLane';
    /**
     * Constant for value 'emergencyLane'
     * @return string 'emergencyLane'
     */
    const VALUE_EMERGENCY_LANE = 'emergencyLane';
    /**
     * Constant for value 'escapeLane'
     * @return string 'escapeLane'
     */
    const VALUE_ESCAPE_LANE = 'escapeLane';
    /**
     * Constant for value 'expressLane'
     * @return string 'expressLane'
     */
    const VALUE_EXPRESS_LANE = 'expressLane';
    /**
     * Constant for value 'hardShoulder'
     * @return string 'hardShoulder'
     */
    const VALUE_HARD_SHOULDER = 'hardShoulder';
    /**
     * Constant for value 'heavyVehicleLane'
     * @return string 'heavyVehicleLane'
     */
    const VALUE_HEAVY_VEHICLE_LANE = 'heavyVehicleLane';
    /**
     * Constant for value 'lane1'
     * @return string 'lane1'
     */
    const VALUE_LANE_1 = 'lane1';
    /**
     * Constant for value 'lane2'
     * @return string 'lane2'
     */
    const VALUE_LANE_2 = 'lane2';
    /**
     * Constant for value 'lane3'
     * @return string 'lane3'
     */
    const VALUE_LANE_3 = 'lane3';
    /**
     * Constant for value 'lane4'
     * @return string 'lane4'
     */
    const VALUE_LANE_4 = 'lane4';
    /**
     * Constant for value 'lane5'
     * @return string 'lane5'
     */
    const VALUE_LANE_5 = 'lane5';
    /**
     * Constant for value 'lane6'
     * @return string 'lane6'
     */
    const VALUE_LANE_6 = 'lane6';
    /**
     * Constant for value 'lane7'
     * @return string 'lane7'
     */
    const VALUE_LANE_7 = 'lane7';
    /**
     * Constant for value 'lane8'
     * @return string 'lane8'
     */
    const VALUE_LANE_8 = 'lane8';
    /**
     * Constant for value 'lane9'
     * @return string 'lane9'
     */
    const VALUE_LANE_9 = 'lane9';
    /**
     * Constant for value 'layBy'
     * @return string 'layBy'
     */
    const VALUE_LAY_BY = 'layBy';
    /**
     * Constant for value 'leftHandTurningLane'
     * @return string 'leftHandTurningLane'
     */
    const VALUE_LEFT_HAND_TURNING_LANE = 'leftHandTurningLane';
    /**
     * Constant for value 'leftLane'
     * @return string 'leftLane'
     */
    const VALUE_LEFT_LANE = 'leftLane';
    /**
     * Constant for value 'localTrafficLane'
     * @return string 'localTrafficLane'
     */
    const VALUE_LOCAL_TRAFFIC_LANE = 'localTrafficLane';
    /**
     * Constant for value 'middleLane'
     * @return string 'middleLane'
     */
    const VALUE_MIDDLE_LANE = 'middleLane';
    /**
     * Constant for value 'opposingLanes'
     * @return string 'opposingLanes'
     */
    const VALUE_OPPOSING_LANES = 'opposingLanes';
    /**
     * Constant for value 'overtakingLane'
     * @return string 'overtakingLane'
     */
    const VALUE_OVERTAKING_LANE = 'overtakingLane';
    /**
     * Constant for value 'rightHandTurningLane'
     * @return string 'rightHandTurningLane'
     */
    const VALUE_RIGHT_HAND_TURNING_LANE = 'rightHandTurningLane';
    /**
     * Constant for value 'rightLane'
     * @return string 'rightLane'
     */
    const VALUE_RIGHT_LANE = 'rightLane';
    /**
     * Constant for value 'rushHourLane'
     * @return string 'rushHourLane'
     */
    const VALUE_RUSH_HOUR_LANE = 'rushHourLane';
    /**
     * Constant for value 'setDownArea'
     * @return string 'setDownArea'
     */
    const VALUE_SET_DOWN_AREA = 'setDownArea';
    /**
     * Constant for value 'slowVehicleLane'
     * @return string 'slowVehicleLane'
     */
    const VALUE_SLOW_VEHICLE_LANE = 'slowVehicleLane';
    /**
     * Constant for value 'throughTrafficLane'
     * @return string 'throughTrafficLane'
     */
    const VALUE_THROUGH_TRAFFIC_LANE = 'throughTrafficLane';
    /**
     * Constant for value 'tidalFlowLane'
     * @return string 'tidalFlowLane'
     */
    const VALUE_TIDAL_FLOW_LANE = 'tidalFlowLane';
    /**
     * Constant for value 'turningLane'
     * @return string 'turningLane'
     */
    const VALUE_TURNING_LANE = 'turningLane';
    /**
     * Constant for value 'verge'
     * @return string 'verge'
     */
    const VALUE_VERGE = 'verge';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_LANES_COMPLETE_CARRIAGEWAY
     * @uses self::VALUE_BUS_LANE
     * @uses self::VALUE_BUS_STOP
     * @uses self::VALUE_CAR_POOL_LANE
     * @uses self::VALUE_CENTRAL_RESERVATION
     * @uses self::VALUE_CRAWLER_LANE
     * @uses self::VALUE_EMERGENCY_LANE
     * @uses self::VALUE_ESCAPE_LANE
     * @uses self::VALUE_EXPRESS_LANE
     * @uses self::VALUE_HARD_SHOULDER
     * @uses self::VALUE_HEAVY_VEHICLE_LANE
     * @uses self::VALUE_LANE_1
     * @uses self::VALUE_LANE_2
     * @uses self::VALUE_LANE_3
     * @uses self::VALUE_LANE_4
     * @uses self::VALUE_LANE_5
     * @uses self::VALUE_LANE_6
     * @uses self::VALUE_LANE_7
     * @uses self::VALUE_LANE_8
     * @uses self::VALUE_LANE_9
     * @uses self::VALUE_LAY_BY
     * @uses self::VALUE_LEFT_HAND_TURNING_LANE
     * @uses self::VALUE_LEFT_LANE
     * @uses self::VALUE_LOCAL_TRAFFIC_LANE
     * @uses self::VALUE_MIDDLE_LANE
     * @uses self::VALUE_OPPOSING_LANES
     * @uses self::VALUE_OVERTAKING_LANE
     * @uses self::VALUE_RIGHT_HAND_TURNING_LANE
     * @uses self::VALUE_RIGHT_LANE
     * @uses self::VALUE_RUSH_HOUR_LANE
     * @uses self::VALUE_SET_DOWN_AREA
     * @uses self::VALUE_SLOW_VEHICLE_LANE
     * @uses self::VALUE_THROUGH_TRAFFIC_LANE
     * @uses self::VALUE_TIDAL_FLOW_LANE
     * @uses self::VALUE_TURNING_LANE
     * @uses self::VALUE_VERGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_LANES_COMPLETE_CARRIAGEWAY,
            self::VALUE_BUS_LANE,
            self::VALUE_BUS_STOP,
            self::VALUE_CAR_POOL_LANE,
            self::VALUE_CENTRAL_RESERVATION,
            self::VALUE_CRAWLER_LANE,
            self::VALUE_EMERGENCY_LANE,
            self::VALUE_ESCAPE_LANE,
            self::VALUE_EXPRESS_LANE,
            self::VALUE_HARD_SHOULDER,
            self::VALUE_HEAVY_VEHICLE_LANE,
            self::VALUE_LANE_1,
            self::VALUE_LANE_2,
            self::VALUE_LANE_3,
            self::VALUE_LANE_4,
            self::VALUE_LANE_5,
            self::VALUE_LANE_6,
            self::VALUE_LANE_7,
            self::VALUE_LANE_8,
            self::VALUE_LANE_9,
            self::VALUE_LAY_BY,
            self::VALUE_LEFT_HAND_TURNING_LANE,
            self::VALUE_LEFT_LANE,
            self::VALUE_LOCAL_TRAFFIC_LANE,
            self::VALUE_MIDDLE_LANE,
            self::VALUE_OPPOSING_LANES,
            self::VALUE_OVERTAKING_LANE,
            self::VALUE_RIGHT_HAND_TURNING_LANE,
            self::VALUE_RIGHT_LANE,
            self::VALUE_RUSH_HOUR_LANE,
            self::VALUE_SET_DOWN_AREA,
            self::VALUE_SLOW_VEHICLE_LANE,
            self::VALUE_THROUGH_TRAFFIC_LANE,
            self::VALUE_TIDAL_FLOW_LANE,
            self::VALUE_TURNING_LANE,
            self::VALUE_VERGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
