<?php

namespace EnumType;

/**
 * This class stands for InjuryStatusTypeEnum EnumType
 * @subpackage Enumerations
 */
class InjuryStatusTypeEnum
{
    /**
     * Constant for value 'dead'
     * @return string 'dead'
     */
    const VALUE_DEAD = 'dead';
    /**
     * Constant for value 'injured'
     * @return string 'injured'
     */
    const VALUE_INJURED = 'injured';
    /**
     * Constant for value 'seriouslyInjured'
     * @return string 'seriouslyInjured'
     */
    const VALUE_SERIOUSLY_INJURED = 'seriouslyInjured';
    /**
     * Constant for value 'slightlyInjured'
     * @return string 'slightlyInjured'
     */
    const VALUE_SLIGHTLY_INJURED = 'slightlyInjured';
    /**
     * Constant for value 'uninjured'
     * @return string 'uninjured'
     */
    const VALUE_UNINJURED = 'uninjured';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEAD
     * @uses self::VALUE_INJURED
     * @uses self::VALUE_SERIOUSLY_INJURED
     * @uses self::VALUE_SLIGHTLY_INJURED
     * @uses self::VALUE_UNINJURED
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEAD,
            self::VALUE_INJURED,
            self::VALUE_SERIOUSLY_INJURED,
            self::VALUE_SLIGHTLY_INJURED,
            self::VALUE_UNINJURED,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
