<?php

namespace EnumType;

/**
 * This class stands for InfrastructureDamageTypeEnum EnumType
 * @subpackage Enumerations
 */
class InfrastructureDamageTypeEnum
{
    /**
     * Constant for value 'burstPipe'
     * @return string 'burstPipe'
     */
    const VALUE_BURST_PIPE = 'burstPipe';
    /**
     * Constant for value 'burstWaterMain'
     * @return string 'burstWaterMain'
     */
    const VALUE_BURST_WATER_MAIN = 'burstWaterMain';
    /**
     * Constant for value 'collapsedSewer'
     * @return string 'collapsedSewer'
     */
    const VALUE_COLLAPSED_SEWER = 'collapsedSewer';
    /**
     * Constant for value 'damagedBridge'
     * @return string 'damagedBridge'
     */
    const VALUE_DAMAGED_BRIDGE = 'damagedBridge';
    /**
     * Constant for value 'damagedCrashBarrier'
     * @return string 'damagedCrashBarrier'
     */
    const VALUE_DAMAGED_CRASH_BARRIER = 'damagedCrashBarrier';
    /**
     * Constant for value 'damagedFlyover'
     * @return string 'damagedFlyover'
     */
    const VALUE_DAMAGED_FLYOVER = 'damagedFlyover';
    /**
     * Constant for value 'damagedGallery'
     * @return string 'damagedGallery'
     */
    const VALUE_DAMAGED_GALLERY = 'damagedGallery';
    /**
     * Constant for value 'damagedGantry'
     * @return string 'damagedGantry'
     */
    const VALUE_DAMAGED_GANTRY = 'damagedGantry';
    /**
     * Constant for value 'damagedRoadSurface'
     * @return string 'damagedRoadSurface'
     */
    const VALUE_DAMAGED_ROAD_SURFACE = 'damagedRoadSurface';
    /**
     * Constant for value 'damagedTunnel'
     * @return string 'damagedTunnel'
     */
    const VALUE_DAMAGED_TUNNEL = 'damagedTunnel';
    /**
     * Constant for value 'damagedViaduct'
     * @return string 'damagedViaduct'
     */
    const VALUE_DAMAGED_VIADUCT = 'damagedViaduct';
    /**
     * Constant for value 'fallenPowerCables'
     * @return string 'fallenPowerCables'
     */
    const VALUE_FALLEN_POWER_CABLES = 'fallenPowerCables';
    /**
     * Constant for value 'gasLeak'
     * @return string 'gasLeak'
     */
    const VALUE_GAS_LEAK = 'gasLeak';
    /**
     * Constant for value 'weakBridge'
     * @return string 'weakBridge'
     */
    const VALUE_WEAK_BRIDGE = 'weakBridge';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BURST_PIPE
     * @uses self::VALUE_BURST_WATER_MAIN
     * @uses self::VALUE_COLLAPSED_SEWER
     * @uses self::VALUE_DAMAGED_BRIDGE
     * @uses self::VALUE_DAMAGED_CRASH_BARRIER
     * @uses self::VALUE_DAMAGED_FLYOVER
     * @uses self::VALUE_DAMAGED_GALLERY
     * @uses self::VALUE_DAMAGED_GANTRY
     * @uses self::VALUE_DAMAGED_ROAD_SURFACE
     * @uses self::VALUE_DAMAGED_TUNNEL
     * @uses self::VALUE_DAMAGED_VIADUCT
     * @uses self::VALUE_FALLEN_POWER_CABLES
     * @uses self::VALUE_GAS_LEAK
     * @uses self::VALUE_WEAK_BRIDGE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BURST_PIPE,
            self::VALUE_BURST_WATER_MAIN,
            self::VALUE_COLLAPSED_SEWER,
            self::VALUE_DAMAGED_BRIDGE,
            self::VALUE_DAMAGED_CRASH_BARRIER,
            self::VALUE_DAMAGED_FLYOVER,
            self::VALUE_DAMAGED_GALLERY,
            self::VALUE_DAMAGED_GANTRY,
            self::VALUE_DAMAGED_ROAD_SURFACE,
            self::VALUE_DAMAGED_TUNNEL,
            self::VALUE_DAMAGED_VIADUCT,
            self::VALUE_FALLEN_POWER_CABLES,
            self::VALUE_GAS_LEAK,
            self::VALUE_WEAK_BRIDGE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
