<?php

namespace EnumType;

/**
 * This class stands for GeneralInstructionToRoadUsersTypeEnum EnumType
 * @subpackage Enumerations
 */
class GeneralInstructionToRoadUsersTypeEnum
{
    /**
     * Constant for value 'allowEmergencyVehiclesToPass'
     * @return string 'allowEmergencyVehiclesToPass'
     */
    const VALUE_ALLOW_EMERGENCY_VEHICLES_TO_PASS = 'allowEmergencyVehiclesToPass';
    /**
     * Constant for value 'approachWithCare'
     * @return string 'approachWithCare'
     */
    const VALUE_APPROACH_WITH_CARE = 'approachWithCare';
    /**
     * Constant for value 'avoidTheArea'
     * @return string 'avoidTheArea'
     */
    const VALUE_AVOID_THE_AREA = 'avoidTheArea';
    /**
     * Constant for value 'closeAllWindowsTurnOffHeaterAndVents'
     * @return string 'closeAllWindowsTurnOffHeaterAndVents'
     */
    const VALUE_CLOSE_ALL_WINDOWS_TURN_OFF_HEATER_AND_VENTS = 'closeAllWindowsTurnOffHeaterAndVents';
    /**
     * Constant for value 'crossJunctionWithCare'
     * @return string 'crossJunctionWithCare'
     */
    const VALUE_CROSS_JUNCTION_WITH_CARE = 'crossJunctionWithCare';
    /**
     * Constant for value 'doNotAllowUnnecessaryGaps'
     * @return string 'doNotAllowUnnecessaryGaps'
     */
    const VALUE_DO_NOT_ALLOW_UNNECESSARY_GAPS = 'doNotAllowUnnecessaryGaps';
    /**
     * Constant for value 'doNotLeaveYourVehicle'
     * @return string 'doNotLeaveYourVehicle'
     */
    const VALUE_DO_NOT_LEAVE_YOUR_VEHICLE = 'doNotLeaveYourVehicle';
    /**
     * Constant for value 'doNotThrowOutAnyBurningObjects'
     * @return string 'doNotThrowOutAnyBurningObjects'
     */
    const VALUE_DO_NOT_THROW_OUT_ANY_BURNING_OBJECTS = 'doNotThrowOutAnyBurningObjects';
    /**
     * Constant for value 'doNotUseNavigationSystems'
     * @return string 'doNotUseNavigationSystems'
     */
    const VALUE_DO_NOT_USE_NAVIGATION_SYSTEMS = 'doNotUseNavigationSystems';
    /**
     * Constant for value 'driveCarefully'
     * @return string 'driveCarefully'
     */
    const VALUE_DRIVE_CAREFULLY = 'driveCarefully';
    /**
     * Constant for value 'driveWithExtremeCaution'
     * @return string 'driveWithExtremeCaution'
     */
    const VALUE_DRIVE_WITH_EXTREME_CAUTION = 'driveWithExtremeCaution';
    /**
     * Constant for value 'flashYourLights'
     * @return string 'flashYourLights'
     */
    const VALUE_FLASH_YOUR_LIGHTS = 'flashYourLights';
    /**
     * Constant for value 'followTheVehicleInFrontSmoothly'
     * @return string 'followTheVehicleInFrontSmoothly'
     */
    const VALUE_FOLLOW_THE_VEHICLE_IN_FRONT_SMOOTHLY = 'followTheVehicleInFrontSmoothly';
    /**
     * Constant for value 'increaseNormalFollowingDistance'
     * @return string 'increaseNormalFollowingDistance'
     */
    const VALUE_INCREASE_NORMAL_FOLLOWING_DISTANCE = 'increaseNormalFollowingDistance';
    /**
     * Constant for value 'inEmergencyWaitForPatrolService'
     * @return string 'inEmergencyWaitForPatrolService'
     */
    const VALUE_IN_EMERGENCY_WAIT_FOR_PATROL_SERVICE = 'inEmergencyWaitForPatrolService';
    /**
     * Constant for value 'keepYourDistance'
     * @return string 'keepYourDistance'
     */
    const VALUE_KEEP_YOUR_DISTANCE = 'keepYourDistance';
    /**
     * Constant for value 'leaveYourVehicleProceedToNextSafePlace'
     * @return string 'leaveYourVehicleProceedToNextSafePlace'
     */
    const VALUE_LEAVE_YOUR_VEHICLE_PROCEED_TO_NEXT_SAFE_PLACE = 'leaveYourVehicleProceedToNextSafePlace';
    /**
     * Constant for value 'noNakedFlames'
     * @return string 'noNakedFlames'
     */
    const VALUE_NO_NAKED_FLAMES = 'noNakedFlames';
    /**
     * Constant for value 'noOvertaking'
     * @return string 'noOvertaking'
     */
    const VALUE_NO_OVERTAKING = 'noOvertaking';
    /**
     * Constant for value 'noSmoking'
     * @return string 'noSmoking'
     */
    const VALUE_NO_SMOKING = 'noSmoking';
    /**
     * Constant for value 'noStopping'
     * @return string 'noStopping'
     */
    const VALUE_NO_STOPPING = 'noStopping';
    /**
     * Constant for value 'noUturns'
     * @return string 'noUturns'
     */
    const VALUE_NO_UTURNS = 'noUturns';
    /**
     * Constant for value 'observeSignals'
     * @return string 'observeSignals'
     */
    const VALUE_OBSERVE_SIGNALS = 'observeSignals';
    /**
     * Constant for value 'observeSigns'
     * @return string 'observeSigns'
     */
    const VALUE_OBSERVE_SIGNS = 'observeSigns';
    /**
     * Constant for value 'onlyTravelIfAbsolutelyNecessary'
     * @return string 'onlyTravelIfAbsolutelyNecessary'
     */
    const VALUE_ONLY_TRAVEL_IF_ABSOLUTELY_NECESSARY = 'onlyTravelIfAbsolutelyNecessary';
    /**
     * Constant for value 'overtakeWithCare'
     * @return string 'overtakeWithCare'
     */
    const VALUE_OVERTAKE_WITH_CARE = 'overtakeWithCare';
    /**
     * Constant for value 'pullOverToTheEdgeOfTheRoadway'
     * @return string 'pullOverToTheEdgeOfTheRoadway'
     */
    const VALUE_PULL_OVER_TO_THE_EDGE_OF_THE_ROADWAY = 'pullOverToTheEdgeOfTheRoadway';
    /**
     * Constant for value 'stopAtNextSafePlace'
     * @return string 'stopAtNextSafePlace'
     */
    const VALUE_STOP_AT_NEXT_SAFE_PLACE = 'stopAtNextSafePlace';
    /**
     * Constant for value 'stopAtNextServiceArea'
     * @return string 'stopAtNextServiceArea'
     */
    const VALUE_STOP_AT_NEXT_SERVICE_AREA = 'stopAtNextServiceArea';
    /**
     * Constant for value 'switchOffEngine'
     * @return string 'switchOffEngine'
     */
    const VALUE_SWITCH_OFF_ENGINE = 'switchOffEngine';
    /**
     * Constant for value 'switchOffMobilePhonesAndTwoWayRadios'
     * @return string 'switchOffMobilePhonesAndTwoWayRadios'
     */
    const VALUE_SWITCH_OFF_MOBILE_PHONES_AND_TWO_WAY_RADIOS = 'switchOffMobilePhonesAndTwoWayRadios';
    /**
     * Constant for value 'testYourBrakes'
     * @return string 'testYourBrakes'
     */
    const VALUE_TEST_YOUR_BRAKES = 'testYourBrakes';
    /**
     * Constant for value 'useBusService'
     * @return string 'useBusService'
     */
    const VALUE_USE_BUS_SERVICE = 'useBusService';
    /**
     * Constant for value 'useFogLights'
     * @return string 'useFogLights'
     */
    const VALUE_USE_FOG_LIGHTS = 'useFogLights';
    /**
     * Constant for value 'useHazardWarningLights'
     * @return string 'useHazardWarningLights'
     */
    const VALUE_USE_HAZARD_WARNING_LIGHTS = 'useHazardWarningLights';
    /**
     * Constant for value 'useHeadlights'
     * @return string 'useHeadlights'
     */
    const VALUE_USE_HEADLIGHTS = 'useHeadlights';
    /**
     * Constant for value 'useRailService'
     * @return string 'useRailService'
     */
    const VALUE_USE_RAIL_SERVICE = 'useRailService';
    /**
     * Constant for value 'useTramService'
     * @return string 'useTramService'
     */
    const VALUE_USE_TRAM_SERVICE = 'useTramService';
    /**
     * Constant for value 'useUndergroundService'
     * @return string 'useUndergroundService'
     */
    const VALUE_USE_UNDERGROUND_SERVICE = 'useUndergroundService';
    /**
     * Constant for value 'waitForEscortVehicle'
     * @return string 'waitForEscortVehicle'
     */
    const VALUE_WAIT_FOR_ESCORT_VEHICLE = 'waitForEscortVehicle';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLOW_EMERGENCY_VEHICLES_TO_PASS
     * @uses self::VALUE_APPROACH_WITH_CARE
     * @uses self::VALUE_AVOID_THE_AREA
     * @uses self::VALUE_CLOSE_ALL_WINDOWS_TURN_OFF_HEATER_AND_VENTS
     * @uses self::VALUE_CROSS_JUNCTION_WITH_CARE
     * @uses self::VALUE_DO_NOT_ALLOW_UNNECESSARY_GAPS
     * @uses self::VALUE_DO_NOT_LEAVE_YOUR_VEHICLE
     * @uses self::VALUE_DO_NOT_THROW_OUT_ANY_BURNING_OBJECTS
     * @uses self::VALUE_DO_NOT_USE_NAVIGATION_SYSTEMS
     * @uses self::VALUE_DRIVE_CAREFULLY
     * @uses self::VALUE_DRIVE_WITH_EXTREME_CAUTION
     * @uses self::VALUE_FLASH_YOUR_LIGHTS
     * @uses self::VALUE_FOLLOW_THE_VEHICLE_IN_FRONT_SMOOTHLY
     * @uses self::VALUE_INCREASE_NORMAL_FOLLOWING_DISTANCE
     * @uses self::VALUE_IN_EMERGENCY_WAIT_FOR_PATROL_SERVICE
     * @uses self::VALUE_KEEP_YOUR_DISTANCE
     * @uses self::VALUE_LEAVE_YOUR_VEHICLE_PROCEED_TO_NEXT_SAFE_PLACE
     * @uses self::VALUE_NO_NAKED_FLAMES
     * @uses self::VALUE_NO_OVERTAKING
     * @uses self::VALUE_NO_SMOKING
     * @uses self::VALUE_NO_STOPPING
     * @uses self::VALUE_NO_UTURNS
     * @uses self::VALUE_OBSERVE_SIGNALS
     * @uses self::VALUE_OBSERVE_SIGNS
     * @uses self::VALUE_ONLY_TRAVEL_IF_ABSOLUTELY_NECESSARY
     * @uses self::VALUE_OVERTAKE_WITH_CARE
     * @uses self::VALUE_PULL_OVER_TO_THE_EDGE_OF_THE_ROADWAY
     * @uses self::VALUE_STOP_AT_NEXT_SAFE_PLACE
     * @uses self::VALUE_STOP_AT_NEXT_SERVICE_AREA
     * @uses self::VALUE_SWITCH_OFF_ENGINE
     * @uses self::VALUE_SWITCH_OFF_MOBILE_PHONES_AND_TWO_WAY_RADIOS
     * @uses self::VALUE_TEST_YOUR_BRAKES
     * @uses self::VALUE_USE_BUS_SERVICE
     * @uses self::VALUE_USE_FOG_LIGHTS
     * @uses self::VALUE_USE_HAZARD_WARNING_LIGHTS
     * @uses self::VALUE_USE_HEADLIGHTS
     * @uses self::VALUE_USE_RAIL_SERVICE
     * @uses self::VALUE_USE_TRAM_SERVICE
     * @uses self::VALUE_USE_UNDERGROUND_SERVICE
     * @uses self::VALUE_WAIT_FOR_ESCORT_VEHICLE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLOW_EMERGENCY_VEHICLES_TO_PASS,
            self::VALUE_APPROACH_WITH_CARE,
            self::VALUE_AVOID_THE_AREA,
            self::VALUE_CLOSE_ALL_WINDOWS_TURN_OFF_HEATER_AND_VENTS,
            self::VALUE_CROSS_JUNCTION_WITH_CARE,
            self::VALUE_DO_NOT_ALLOW_UNNECESSARY_GAPS,
            self::VALUE_DO_NOT_LEAVE_YOUR_VEHICLE,
            self::VALUE_DO_NOT_THROW_OUT_ANY_BURNING_OBJECTS,
            self::VALUE_DO_NOT_USE_NAVIGATION_SYSTEMS,
            self::VALUE_DRIVE_CAREFULLY,
            self::VALUE_DRIVE_WITH_EXTREME_CAUTION,
            self::VALUE_FLASH_YOUR_LIGHTS,
            self::VALUE_FOLLOW_THE_VEHICLE_IN_FRONT_SMOOTHLY,
            self::VALUE_INCREASE_NORMAL_FOLLOWING_DISTANCE,
            self::VALUE_IN_EMERGENCY_WAIT_FOR_PATROL_SERVICE,
            self::VALUE_KEEP_YOUR_DISTANCE,
            self::VALUE_LEAVE_YOUR_VEHICLE_PROCEED_TO_NEXT_SAFE_PLACE,
            self::VALUE_NO_NAKED_FLAMES,
            self::VALUE_NO_OVERTAKING,
            self::VALUE_NO_SMOKING,
            self::VALUE_NO_STOPPING,
            self::VALUE_NO_UTURNS,
            self::VALUE_OBSERVE_SIGNALS,
            self::VALUE_OBSERVE_SIGNS,
            self::VALUE_ONLY_TRAVEL_IF_ABSOLUTELY_NECESSARY,
            self::VALUE_OVERTAKE_WITH_CARE,
            self::VALUE_PULL_OVER_TO_THE_EDGE_OF_THE_ROADWAY,
            self::VALUE_STOP_AT_NEXT_SAFE_PLACE,
            self::VALUE_STOP_AT_NEXT_SERVICE_AREA,
            self::VALUE_SWITCH_OFF_ENGINE,
            self::VALUE_SWITCH_OFF_MOBILE_PHONES_AND_TWO_WAY_RADIOS,
            self::VALUE_TEST_YOUR_BRAKES,
            self::VALUE_USE_BUS_SERVICE,
            self::VALUE_USE_FOG_LIGHTS,
            self::VALUE_USE_HAZARD_WARNING_LIGHTS,
            self::VALUE_USE_HEADLIGHTS,
            self::VALUE_USE_RAIL_SERVICE,
            self::VALUE_USE_TRAM_SERVICE,
            self::VALUE_USE_UNDERGROUND_SERVICE,
            self::VALUE_WAIT_FOR_ESCORT_VEHICLE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
