<?php

namespace EnumType;

/**
 * This class stands for FareClassFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for FareClass Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class FareClassFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_0'
     * @return string 'pti23_0'
     */
    const VALUE_PTI_23_0 = 'pti23_0';
    /**
     * Constant for value 'pti23_6'
     * @return string 'pti23_6'
     */
    const VALUE_PTI_23_6 = 'pti23_6';
    /**
     * Constant for value 'firstClass'
     * @return string 'firstClass'
     */
    const VALUE_FIRST_CLASS = 'firstClass';
    /**
     * Constant for value 'pti23_7'
     * @return string 'pti23_7'
     */
    const VALUE_PTI_23_7 = 'pti23_7';
    /**
     * Constant for value 'secondClass'
     * @return string 'secondClass'
     */
    const VALUE_SECOND_CLASS = 'secondClass';
    /**
     * Constant for value 'pti23_8'
     * @return string 'pti23_8'
     */
    const VALUE_PTI_23_8 = 'pti23_8';
    /**
     * Constant for value 'thirdClass'
     * @return string 'thirdClass'
     */
    const VALUE_THIRD_CLASS = 'thirdClass';
    /**
     * Constant for value 'pti23_9'
     * @return string 'pti23_9'
     */
    const VALUE_PTI_23_9 = 'pti23_9';
    /**
     * Constant for value 'economyClass'
     * @return string 'economyClass'
     */
    const VALUE_ECONOMY_CLASS = 'economyClass';
    /**
     * Constant for value 'pti23_10'
     * @return string 'pti23_10'
     */
    const VALUE_PTI_23_10 = 'pti23_10';
    /**
     * Constant for value 'businessClass'
     * @return string 'businessClass'
     */
    const VALUE_BUSINESS_CLASS = 'businessClass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_0
     * @uses self::VALUE_PTI_23_6
     * @uses self::VALUE_FIRST_CLASS
     * @uses self::VALUE_PTI_23_7
     * @uses self::VALUE_SECOND_CLASS
     * @uses self::VALUE_PTI_23_8
     * @uses self::VALUE_THIRD_CLASS
     * @uses self::VALUE_PTI_23_9
     * @uses self::VALUE_ECONOMY_CLASS
     * @uses self::VALUE_PTI_23_10
     * @uses self::VALUE_BUSINESS_CLASS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_0,
            self::VALUE_PTI_23_6,
            self::VALUE_FIRST_CLASS,
            self::VALUE_PTI_23_7,
            self::VALUE_SECOND_CLASS,
            self::VALUE_PTI_23_8,
            self::VALUE_THIRD_CLASS,
            self::VALUE_PTI_23_9,
            self::VALUE_ECONOMY_CLASS,
            self::VALUE_PTI_23_10,
            self::VALUE_BUSINESS_CLASS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
