<?php

namespace EnumType;

/**
 * This class stands for FacilityCategoryEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Generic catégory of a facility.
 * @subpackage Enumerations
 */
class FacilityCategoryEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'fixedEquipment'
     * @return string 'fixedEquipment'
     */
    const VALUE_FIXED_EQUIPMENT = 'fixedEquipment';
    /**
     * Constant for value 'serviceProvidedByIndividual'
     * @return string 'serviceProvidedByIndividual'
     */
    const VALUE_SERVICE_PROVIDED_BY_INDIVIDUAL = 'serviceProvidedByIndividual';
    /**
     * Constant for value 'serviceForPersonalDevice'
     * @return string 'serviceForPersonalDevice'
     */
    const VALUE_SERVICE_FOR_PERSONAL_DEVICE = 'serviceForPersonalDevice';
    /**
     * Constant for value 'reservedArea'
     * @return string 'reservedArea'
     */
    const VALUE_RESERVED_AREA = 'reservedArea';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FIXED_EQUIPMENT
     * @uses self::VALUE_SERVICE_PROVIDED_BY_INDIVIDUAL
     * @uses self::VALUE_SERVICE_FOR_PERSONAL_DEVICE
     * @uses self::VALUE_RESERVED_AREA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FIXED_EQUIPMENT,
            self::VALUE_SERVICE_PROVIDED_BY_INDIVIDUAL,
            self::VALUE_SERVICE_FOR_PERSONAL_DEVICE,
            self::VALUE_RESERVED_AREA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
