<?php

namespace EnumType;

/**
 * This class stands for EquipmentSubReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Equipment incident sub reason types.
 * @subpackage Enumerations
 */
class EquipmentSubReasonEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pointsProblem'
     * @return string 'pointsProblem'
     */
    const VALUE_POINTS_PROBLEM = 'pointsProblem';
    /**
     * Constant for value 'pointsFailure'
     * @return string 'pointsFailure'
     */
    const VALUE_POINTS_FAILURE = 'pointsFailure';
    /**
     * Constant for value 'signalProblem'
     * @return string 'signalProblem'
     */
    const VALUE_SIGNAL_PROBLEM = 'signalProblem';
    /**
     * Constant for value 'trainWarningSystemProblem'
     * @return string 'trainWarningSystemProblem'
     */
    const VALUE_TRAIN_WARNING_SYSTEM_PROBLEM = 'trainWarningSystemProblem';
    /**
     * Constant for value 'trackCircuitProblem'
     * @return string 'trackCircuitProblem'
     */
    const VALUE_TRACK_CIRCUIT_PROBLEM = 'trackCircuitProblem';
    /**
     * Constant for value 'signalFailure'
     * @return string 'signalFailure'
     */
    const VALUE_SIGNAL_FAILURE = 'signalFailure';
    /**
     * Constant for value 'signalAndSwitchFailure'
     * @return string 'signalAndSwitchFailure'
     */
    const VALUE_SIGNAL_AND_SWITCH_FAILURE = 'signalAndSwitchFailure';
    /**
     * Constant for value 'derailment'
     * @return string 'derailment'
     */
    const VALUE_DERAILMENT = 'derailment';
    /**
     * Constant for value 'engineFailure'
     * @return string 'engineFailure'
     */
    const VALUE_ENGINE_FAILURE = 'engineFailure';
    /**
     * Constant for value 'tractionFailure'
     * @return string 'tractionFailure'
     */
    const VALUE_TRACTION_FAILURE = 'tractionFailure';
    /**
     * Constant for value 'breakDown'
     * @return string 'breakDown'
     */
    const VALUE_BREAK_DOWN = 'breakDown';
    /**
     * Constant for value 'technicalProblem'
     * @return string 'technicalProblem'
     */
    const VALUE_TECHNICAL_PROBLEM = 'technicalProblem';
    /**
     * Constant for value 'brokenRail'
     * @return string 'brokenRail'
     */
    const VALUE_BROKEN_RAIL = 'brokenRail';
    /**
     * Constant for value 'poorRailConditions'
     * @return string 'poorRailConditions'
     */
    const VALUE_POOR_RAIL_CONDITIONS = 'poorRailConditions';
    /**
     * Constant for value 'wheelImpactLoad'
     * @return string 'wheelImpactLoad'
     */
    const VALUE_WHEEL_IMPACT_LOAD = 'wheelImpactLoad';
    /**
     * Constant for value 'lackOfOperationalStock'
     * @return string 'lackOfOperationalStock'
     */
    const VALUE_LACK_OF_OPERATIONAL_STOCK = 'lackOfOperationalStock';
    /**
     * Constant for value 'defectiveFireAlarmEquipment'
     * @return string 'defectiveFireAlarmEquipment'
     */
    const VALUE_DEFECTIVE_FIRE_ALARM_EQUIPMENT = 'defectiveFireAlarmEquipment';
    /**
     * Constant for value 'defectivePlatformEdgeDoors'
     * @return string 'defectivePlatformEdgeDoors'
     */
    const VALUE_DEFECTIVE_PLATFORM_EDGE_DOORS = 'defectivePlatformEdgeDoors';
    /**
     * Constant for value 'defectiveCctv'
     * @return string 'defectiveCctv'
     */
    const VALUE_DEFECTIVE_CCTV = 'defectiveCctv';
    /**
     * Constant for value 'defectivePublicAnnouncementSystem'
     * @return string 'defectivePublicAnnouncementSystem'
     */
    const VALUE_DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM = 'defectivePublicAnnouncementSystem';
    /**
     * Constant for value 'ticketingSystemNotAvailable'
     * @return string 'ticketingSystemNotAvailable'
     */
    const VALUE_TICKETING_SYSTEM_NOT_AVAILABLE = 'ticketingSystemNotAvailable';
    /**
     * Constant for value 'leveCrossingFailure'
     * @return string 'leveCrossingFailure'
     */
    const VALUE_LEVE_CROSSING_FAILURE = 'leveCrossingFailure';
    /**
     * Constant for value 'repairWork'
     * @return string 'repairWork'
     */
    const VALUE_REPAIR_WORK = 'repairWork';
    /**
     * Constant for value 'constructionWork'
     * @return string 'constructionWork'
     */
    const VALUE_CONSTRUCTION_WORK = 'constructionWork';
    /**
     * Constant for value 'maintenanceWork'
     * @return string 'maintenanceWork'
     */
    const VALUE_MAINTENANCE_WORK = 'maintenanceWork';
    /**
     * Constant for value 'emergencyEngineeringWork'
     * @return string 'emergencyEngineeringWork'
     */
    const VALUE_EMERGENCY_ENGINEERING_WORK = 'emergencyEngineeringWork';
    /**
     * Constant for value 'lateFinishToEngineeringWork'
     * @return string 'lateFinishToEngineeringWork'
     */
    const VALUE_LATE_FINISH_TO_ENGINEERING_WORK = 'lateFinishToEngineeringWork';
    /**
     * Constant for value 'powerProblem'
     * @return string 'powerProblem'
     */
    const VALUE_POWER_PROBLEM = 'powerProblem';
    /**
     * Constant for value 'oveheadWireFailure'
     * @return string 'oveheadWireFailure'
     */
    const VALUE_OVEHEAD_WIRE_FAILURE = 'oveheadWireFailure';
    /**
     * Constant for value 'fuelProblem'
     * @return string 'fuelProblem'
     */
    const VALUE_FUEL_PROBLEM = 'fuelProblem';
    /**
     * Constant for value 'swingBridgeFailure'
     * @return string 'swingBridgeFailure'
     */
    const VALUE_SWING_BRIDGE_FAILURE = 'swingBridgeFailure';
    /**
     * Constant for value 'escalatorFailure'
     * @return string 'escalatorFailure'
     */
    const VALUE_ESCALATOR_FAILURE = 'escalatorFailure';
    /**
     * Constant for value 'liftFailure'
     * @return string 'liftFailure'
     */
    const VALUE_LIFT_FAILURE = 'liftFailure';
    /**
     * Constant for value 'gangwayProblem'
     * @return string 'gangwayProblem'
     */
    const VALUE_GANGWAY_PROBLEM = 'gangwayProblem';
    /**
     * Constant for value 'closedForMaintenance'
     * @return string 'closedForMaintenance'
     */
    const VALUE_CLOSED_FOR_MAINTENANCE = 'closedForMaintenance';
    /**
     * Constant for value 'fuelShortage'
     * @return string 'fuelShortage'
     */
    const VALUE_FUEL_SHORTAGE = 'fuelShortage';
    /**
     * Constant for value 'deicingWork'
     * @return string 'deicingWork'
     */
    const VALUE_DEICING_WORK = 'deicingWork';
    /**
     * Constant for value 'wheelProblem'
     * @return string 'wheelProblem'
     */
    const VALUE_WHEEL_PROBLEM = 'wheelProblem';
    /**
     * Constant for value 'slipperyTrack'
     * @return string 'slipperyTrack'
     */
    const VALUE_SLIPPERY_TRACK = 'slipperyTrack';
    /**
     * Constant for value 'luggageCarouselProblem'
     * @return string 'luggageCarouselProblem'
     */
    const VALUE_LUGGAGE_CAROUSEL_PROBLEM = 'luggageCarouselProblem';
    /**
     * Constant for value 'undefinedEquipmentProblem'
     * @return string 'undefinedEquipmentProblem'
     */
    const VALUE_UNDEFINED_EQUIPMENT_PROBLEM = 'undefinedEquipmentProblem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_POINTS_PROBLEM
     * @uses self::VALUE_POINTS_FAILURE
     * @uses self::VALUE_SIGNAL_PROBLEM
     * @uses self::VALUE_TRAIN_WARNING_SYSTEM_PROBLEM
     * @uses self::VALUE_TRACK_CIRCUIT_PROBLEM
     * @uses self::VALUE_SIGNAL_FAILURE
     * @uses self::VALUE_SIGNAL_AND_SWITCH_FAILURE
     * @uses self::VALUE_DERAILMENT
     * @uses self::VALUE_ENGINE_FAILURE
     * @uses self::VALUE_TRACTION_FAILURE
     * @uses self::VALUE_BREAK_DOWN
     * @uses self::VALUE_TECHNICAL_PROBLEM
     * @uses self::VALUE_BROKEN_RAIL
     * @uses self::VALUE_POOR_RAIL_CONDITIONS
     * @uses self::VALUE_WHEEL_IMPACT_LOAD
     * @uses self::VALUE_LACK_OF_OPERATIONAL_STOCK
     * @uses self::VALUE_DEFECTIVE_FIRE_ALARM_EQUIPMENT
     * @uses self::VALUE_DEFECTIVE_PLATFORM_EDGE_DOORS
     * @uses self::VALUE_DEFECTIVE_CCTV
     * @uses self::VALUE_DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM
     * @uses self::VALUE_TICKETING_SYSTEM_NOT_AVAILABLE
     * @uses self::VALUE_LEVE_CROSSING_FAILURE
     * @uses self::VALUE_REPAIR_WORK
     * @uses self::VALUE_CONSTRUCTION_WORK
     * @uses self::VALUE_MAINTENANCE_WORK
     * @uses self::VALUE_EMERGENCY_ENGINEERING_WORK
     * @uses self::VALUE_LATE_FINISH_TO_ENGINEERING_WORK
     * @uses self::VALUE_POWER_PROBLEM
     * @uses self::VALUE_OVEHEAD_WIRE_FAILURE
     * @uses self::VALUE_FUEL_PROBLEM
     * @uses self::VALUE_SWING_BRIDGE_FAILURE
     * @uses self::VALUE_ESCALATOR_FAILURE
     * @uses self::VALUE_LIFT_FAILURE
     * @uses self::VALUE_GANGWAY_PROBLEM
     * @uses self::VALUE_CLOSED_FOR_MAINTENANCE
     * @uses self::VALUE_FUEL_SHORTAGE
     * @uses self::VALUE_DEICING_WORK
     * @uses self::VALUE_WHEEL_PROBLEM
     * @uses self::VALUE_SLIPPERY_TRACK
     * @uses self::VALUE_LUGGAGE_CAROUSEL_PROBLEM
     * @uses self::VALUE_UNDEFINED_EQUIPMENT_PROBLEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_POINTS_PROBLEM,
            self::VALUE_POINTS_FAILURE,
            self::VALUE_SIGNAL_PROBLEM,
            self::VALUE_TRAIN_WARNING_SYSTEM_PROBLEM,
            self::VALUE_TRACK_CIRCUIT_PROBLEM,
            self::VALUE_SIGNAL_FAILURE,
            self::VALUE_SIGNAL_AND_SWITCH_FAILURE,
            self::VALUE_DERAILMENT,
            self::VALUE_ENGINE_FAILURE,
            self::VALUE_TRACTION_FAILURE,
            self::VALUE_BREAK_DOWN,
            self::VALUE_TECHNICAL_PROBLEM,
            self::VALUE_BROKEN_RAIL,
            self::VALUE_POOR_RAIL_CONDITIONS,
            self::VALUE_WHEEL_IMPACT_LOAD,
            self::VALUE_LACK_OF_OPERATIONAL_STOCK,
            self::VALUE_DEFECTIVE_FIRE_ALARM_EQUIPMENT,
            self::VALUE_DEFECTIVE_PLATFORM_EDGE_DOORS,
            self::VALUE_DEFECTIVE_CCTV,
            self::VALUE_DEFECTIVE_PUBLIC_ANNOUNCEMENT_SYSTEM,
            self::VALUE_TICKETING_SYSTEM_NOT_AVAILABLE,
            self::VALUE_LEVE_CROSSING_FAILURE,
            self::VALUE_REPAIR_WORK,
            self::VALUE_CONSTRUCTION_WORK,
            self::VALUE_MAINTENANCE_WORK,
            self::VALUE_EMERGENCY_ENGINEERING_WORK,
            self::VALUE_LATE_FINISH_TO_ENGINEERING_WORK,
            self::VALUE_POWER_PROBLEM,
            self::VALUE_OVEHEAD_WIRE_FAILURE,
            self::VALUE_FUEL_PROBLEM,
            self::VALUE_SWING_BRIDGE_FAILURE,
            self::VALUE_ESCALATOR_FAILURE,
            self::VALUE_LIFT_FAILURE,
            self::VALUE_GANGWAY_PROBLEM,
            self::VALUE_CLOSED_FOR_MAINTENANCE,
            self::VALUE_FUEL_SHORTAGE,
            self::VALUE_DEICING_WORK,
            self::VALUE_WHEEL_PROBLEM,
            self::VALUE_SLIPPERY_TRACK,
            self::VALUE_LUGGAGE_CAROUSEL_PROBLEM,
            self::VALUE_UNDEFINED_EQUIPMENT_PROBLEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
