<?php

namespace EnumType;

/**
 * This class stands for EquipmentStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Availabilityload status of a EQUIPMENT.
 * @subpackage Enumerations
 */
class EquipmentStatusEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'available'
     * @return string 'available'
     */
    const VALUE_AVAILABLE = 'available';
    /**
     * Constant for value 'notAvailable'
     * @return string 'notAvailable'
     */
    const VALUE_NOT_AVAILABLE = 'notAvailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_NOT_AVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_AVAILABLE,
            self::VALUE_NOT_AVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
