<?php

namespace EnumType;

/**
 * This class stands for EquipmentOrSystemTypeEnum EnumType
 * @subpackage Enumerations
 */
class EquipmentOrSystemTypeEnum
{
    /**
     * Constant for value 'automatedTollSystem'
     * @return string 'automatedTollSystem'
     */
    const VALUE_AUTOMATED_TOLL_SYSTEM = 'automatedTollSystem';
    /**
     * Constant for value 'emergencyRoadsideTelephones'
     * @return string 'emergencyRoadsideTelephones'
     */
    const VALUE_EMERGENCY_ROADSIDE_TELEPHONES = 'emergencyRoadsideTelephones';
    /**
     * Constant for value 'galleryLights'
     * @return string 'galleryLights'
     */
    const VALUE_GALLERY_LIGHTS = 'galleryLights';
    /**
     * Constant for value 'laneControlSigns'
     * @return string 'laneControlSigns'
     */
    const VALUE_LANE_CONTROL_SIGNS = 'laneControlSigns';
    /**
     * Constant for value 'levelCrossing'
     * @return string 'levelCrossing'
     */
    const VALUE_LEVEL_CROSSING = 'levelCrossing';
    /**
     * Constant for value 'matrixSigns'
     * @return string 'matrixSigns'
     */
    const VALUE_MATRIX_SIGNS = 'matrixSigns';
    /**
     * Constant for value 'rampControls'
     * @return string 'rampControls'
     */
    const VALUE_RAMP_CONTROLS = 'rampControls';
    /**
     * Constant for value 'roadsideCommunicationsSystem'
     * @return string 'roadsideCommunicationsSystem'
     */
    const VALUE_ROADSIDE_COMMUNICATIONS_SYSTEM = 'roadsideCommunicationsSystem';
    /**
     * Constant for value 'roadsidePowerSystem'
     * @return string 'roadsidePowerSystem'
     */
    const VALUE_ROADSIDE_POWER_SYSTEM = 'roadsidePowerSystem';
    /**
     * Constant for value 'speedControlSigns'
     * @return string 'speedControlSigns'
     */
    const VALUE_SPEED_CONTROL_SIGNS = 'speedControlSigns';
    /**
     * Constant for value 'streetLighting'
     * @return string 'streetLighting'
     */
    const VALUE_STREET_LIGHTING = 'streetLighting';
    /**
     * Constant for value 'temporaryTrafficLights'
     * @return string 'temporaryTrafficLights'
     */
    const VALUE_TEMPORARY_TRAFFIC_LIGHTS = 'temporaryTrafficLights';
    /**
     * Constant for value 'tollGates'
     * @return string 'tollGates'
     */
    const VALUE_TOLL_GATES = 'tollGates';
    /**
     * Constant for value 'trafficLightSets'
     * @return string 'trafficLightSets'
     */
    const VALUE_TRAFFIC_LIGHT_SETS = 'trafficLightSets';
    /**
     * Constant for value 'trafficSignals'
     * @return string 'trafficSignals'
     */
    const VALUE_TRAFFIC_SIGNALS = 'trafficSignals';
    /**
     * Constant for value 'tunnelLights'
     * @return string 'tunnelLights'
     */
    const VALUE_TUNNEL_LIGHTS = 'tunnelLights';
    /**
     * Constant for value 'tunnelVentilation'
     * @return string 'tunnelVentilation'
     */
    const VALUE_TUNNEL_VENTILATION = 'tunnelVentilation';
    /**
     * Constant for value 'variableMessageSigns'
     * @return string 'variableMessageSigns'
     */
    const VALUE_VARIABLE_MESSAGE_SIGNS = 'variableMessageSigns';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTOMATED_TOLL_SYSTEM
     * @uses self::VALUE_EMERGENCY_ROADSIDE_TELEPHONES
     * @uses self::VALUE_GALLERY_LIGHTS
     * @uses self::VALUE_LANE_CONTROL_SIGNS
     * @uses self::VALUE_LEVEL_CROSSING
     * @uses self::VALUE_MATRIX_SIGNS
     * @uses self::VALUE_RAMP_CONTROLS
     * @uses self::VALUE_ROADSIDE_COMMUNICATIONS_SYSTEM
     * @uses self::VALUE_ROADSIDE_POWER_SYSTEM
     * @uses self::VALUE_SPEED_CONTROL_SIGNS
     * @uses self::VALUE_STREET_LIGHTING
     * @uses self::VALUE_TEMPORARY_TRAFFIC_LIGHTS
     * @uses self::VALUE_TOLL_GATES
     * @uses self::VALUE_TRAFFIC_LIGHT_SETS
     * @uses self::VALUE_TRAFFIC_SIGNALS
     * @uses self::VALUE_TUNNEL_LIGHTS
     * @uses self::VALUE_TUNNEL_VENTILATION
     * @uses self::VALUE_VARIABLE_MESSAGE_SIGNS
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTOMATED_TOLL_SYSTEM,
            self::VALUE_EMERGENCY_ROADSIDE_TELEPHONES,
            self::VALUE_GALLERY_LIGHTS,
            self::VALUE_LANE_CONTROL_SIGNS,
            self::VALUE_LEVEL_CROSSING,
            self::VALUE_MATRIX_SIGNS,
            self::VALUE_RAMP_CONTROLS,
            self::VALUE_ROADSIDE_COMMUNICATIONS_SYSTEM,
            self::VALUE_ROADSIDE_POWER_SYSTEM,
            self::VALUE_SPEED_CONTROL_SIGNS,
            self::VALUE_STREET_LIGHTING,
            self::VALUE_TEMPORARY_TRAFFIC_LIGHTS,
            self::VALUE_TOLL_GATES,
            self::VALUE_TRAFFIC_LIGHT_SETS,
            self::VALUE_TRAFFIC_SIGNALS,
            self::VALUE_TUNNEL_LIGHTS,
            self::VALUE_TUNNEL_VENTILATION,
            self::VALUE_VARIABLE_MESSAGE_SIGNS,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
