<?php

namespace EnumType;

/**
 * This class stands for EquipmentOrSystemFaultTypeEnum EnumType
 * @subpackage Enumerations
 */
class EquipmentOrSystemFaultTypeEnum
{
    /**
     * Constant for value 'notWorking'
     * @return string 'notWorking'
     */
    const VALUE_NOT_WORKING = 'notWorking';
    /**
     * Constant for value 'outOfService'
     * @return string 'outOfService'
     */
    const VALUE_OUT_OF_SERVICE = 'outOfService';
    /**
     * Constant for value 'workingIncorrectly'
     * @return string 'workingIncorrectly'
     */
    const VALUE_WORKING_INCORRECTLY = 'workingIncorrectly';
    /**
     * Constant for value 'workingIntermittently'
     * @return string 'workingIntermittently'
     */
    const VALUE_WORKING_INTERMITTENTLY = 'workingIntermittently';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_WORKING
     * @uses self::VALUE_OUT_OF_SERVICE
     * @uses self::VALUE_WORKING_INCORRECTLY
     * @uses self::VALUE_WORKING_INTERMITTENTLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_WORKING,
            self::VALUE_OUT_OF_SERVICE,
            self::VALUE_WORKING_INCORRECTLY,
            self::VALUE_WORKING_INTERMITTENTLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
