<?php

namespace EnumType;

/**
 * This class stands for EnvironmentalObstructionTypeEnum EnumType
 * @subpackage Enumerations
 */
class EnvironmentalObstructionTypeEnum
{
    /**
     * Constant for value 'avalanches'
     * @return string 'avalanches'
     */
    const VALUE_AVALANCHES = 'avalanches';
    /**
     * Constant for value 'earthquakeDamage'
     * @return string 'earthquakeDamage'
     */
    const VALUE_EARTHQUAKE_DAMAGE = 'earthquakeDamage';
    /**
     * Constant for value 'fallenTrees'
     * @return string 'fallenTrees'
     */
    const VALUE_FALLEN_TREES = 'fallenTrees';
    /**
     * Constant for value 'fallingIce'
     * @return string 'fallingIce'
     */
    const VALUE_FALLING_ICE = 'fallingIce';
    /**
     * Constant for value 'fallingLightIceOrSnow'
     * @return string 'fallingLightIceOrSnow'
     */
    const VALUE_FALLING_LIGHT_ICE_OR_SNOW = 'fallingLightIceOrSnow';
    /**
     * Constant for value 'flashFloods'
     * @return string 'flashFloods'
     */
    const VALUE_FLASH_FLOODS = 'flashFloods';
    /**
     * Constant for value 'flooding'
     * @return string 'flooding'
     */
    const VALUE_FLOODING = 'flooding';
    /**
     * Constant for value 'forestFire'
     * @return string 'forestFire'
     */
    const VALUE_FOREST_FIRE = 'forestFire';
    /**
     * Constant for value 'grassFire'
     * @return string 'grassFire'
     */
    const VALUE_GRASS_FIRE = 'grassFire';
    /**
     * Constant for value 'landslips'
     * @return string 'landslips'
     */
    const VALUE_LANDSLIPS = 'landslips';
    /**
     * Constant for value 'mudSlide'
     * @return string 'mudSlide'
     */
    const VALUE_MUD_SLIDE = 'mudSlide';
    /**
     * Constant for value 'sewerOverflow'
     * @return string 'sewerOverflow'
     */
    const VALUE_SEWER_OVERFLOW = 'sewerOverflow';
    /**
     * Constant for value 'rockfalls'
     * @return string 'rockfalls'
     */
    const VALUE_ROCKFALLS = 'rockfalls';
    /**
     * Constant for value 'seriousFire'
     * @return string 'seriousFire'
     */
    const VALUE_SERIOUS_FIRE = 'seriousFire';
    /**
     * Constant for value 'smokeOrFumes'
     * @return string 'smokeOrFumes'
     */
    const VALUE_SMOKE_OR_FUMES = 'smokeOrFumes';
    /**
     * Constant for value 'stormDamage'
     * @return string 'stormDamage'
     */
    const VALUE_STORM_DAMAGE = 'stormDamage';
    /**
     * Constant for value 'subsidence'
     * @return string 'subsidence'
     */
    const VALUE_SUBSIDENCE = 'subsidence';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVALANCHES
     * @uses self::VALUE_EARTHQUAKE_DAMAGE
     * @uses self::VALUE_FALLEN_TREES
     * @uses self::VALUE_FALLING_ICE
     * @uses self::VALUE_FALLING_LIGHT_ICE_OR_SNOW
     * @uses self::VALUE_FLASH_FLOODS
     * @uses self::VALUE_FLOODING
     * @uses self::VALUE_FOREST_FIRE
     * @uses self::VALUE_GRASS_FIRE
     * @uses self::VALUE_LANDSLIPS
     * @uses self::VALUE_MUD_SLIDE
     * @uses self::VALUE_SEWER_OVERFLOW
     * @uses self::VALUE_ROCKFALLS
     * @uses self::VALUE_SERIOUS_FIRE
     * @uses self::VALUE_SMOKE_OR_FUMES
     * @uses self::VALUE_STORM_DAMAGE
     * @uses self::VALUE_SUBSIDENCE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVALANCHES,
            self::VALUE_EARTHQUAKE_DAMAGE,
            self::VALUE_FALLEN_TREES,
            self::VALUE_FALLING_ICE,
            self::VALUE_FALLING_LIGHT_ICE_OR_SNOW,
            self::VALUE_FLASH_FLOODS,
            self::VALUE_FLOODING,
            self::VALUE_FOREST_FIRE,
            self::VALUE_GRASS_FIRE,
            self::VALUE_LANDSLIPS,
            self::VALUE_MUD_SLIDE,
            self::VALUE_SEWER_OVERFLOW,
            self::VALUE_ROCKFALLS,
            self::VALUE_SERIOUS_FIRE,
            self::VALUE_SMOKE_OR_FUMES,
            self::VALUE_STORM_DAMAGE,
            self::VALUE_SUBSIDENCE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
