<?php

namespace EnumType;

/**
 * This class stands for EnvironmentReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Environment incident reason types TPEG Pti18_4/TPEG Pti_22.
 * @subpackage Enumerations
 */
class EnvironmentReasonEnumeration
{
    /**
     * Constant for value 'pti22_0'
     * @return string 'pti22_0'
     */
    const VALUE_PTI_22_0 = 'pti22_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti22_1'
     * @return string 'pti22_1'
     */
    const VALUE_PTI_22_1 = 'pti22_1';
    /**
     * Constant for value 'fog'
     * @return string 'fog'
     */
    const VALUE_FOG = 'fog';
    /**
     * Constant for value 'pti22_2'
     * @return string 'pti22_2'
     */
    const VALUE_PTI_22_2 = 'pti22_2';
    /**
     * Constant for value 'roughSea'
     * @return string 'roughSea'
     */
    const VALUE_ROUGH_SEA = 'roughSea';
    /**
     * Constant for value 'pti22_3'
     * @return string 'pti22_3'
     */
    const VALUE_PTI_22_3 = 'pti22_3';
    /**
     * Constant for value 'heavySnowFall'
     * @return string 'heavySnowFall'
     */
    const VALUE_HEAVY_SNOW_FALL = 'heavySnowFall';
    /**
     * Constant for value 'pti22_3_Alias_1'
     * @return string 'pti22_3_Alias_1'
     */
    const VALUE_PTI_22_3_ALIAS_1 = 'pti22_3_Alias_1';
    /**
     * Constant for value 'driftingSnow'
     * @return string 'driftingSnow'
     */
    const VALUE_DRIFTING_SNOW = 'driftingSnow';
    /**
     * Constant for value 'pti22_3_Alias_2'
     * @return string 'pti22_3_Alias_2'
     */
    const VALUE_PTI_22_3_ALIAS_2 = 'pti22_3_Alias_2';
    /**
     * Constant for value 'blizzardConditions'
     * @return string 'blizzardConditions'
     */
    const VALUE_BLIZZARD_CONDITIONS = 'blizzardConditions';
    /**
     * Constant for value 'pti22_4'
     * @return string 'pti22_4'
     */
    const VALUE_PTI_22_4 = 'pti22_4';
    /**
     * Constant for value 'heavyRain'
     * @return string 'heavyRain'
     */
    const VALUE_HEAVY_RAIN = 'heavyRain';
    /**
     * Constant for value 'pti22_5'
     * @return string 'pti22_5'
     */
    const VALUE_PTI_22_5 = 'pti22_5';
    /**
     * Constant for value 'strongWinds'
     * @return string 'strongWinds'
     */
    const VALUE_STRONG_WINDS = 'strongWinds';
    /**
     * Constant for value 'pti22_5_Alias_1'
     * @return string 'pti22_5_Alias_1'
     */
    const VALUE_PTI_22_5_ALIAS_1 = 'pti22_5_Alias_1';
    /**
     * Constant for value 'stormConditions'
     * @return string 'stormConditions'
     */
    const VALUE_STORM_CONDITIONS = 'stormConditions';
    /**
     * Constant for value 'pti22_5_Alias_2'
     * @return string 'pti22_5_Alias_2'
     */
    const VALUE_PTI_22_5_ALIAS_2 = 'pti22_5_Alias_2';
    /**
     * Constant for value 'stormDamage'
     * @return string 'stormDamage'
     */
    const VALUE_STORM_DAMAGE = 'stormDamage';
    /**
     * Constant for value 'pti22_6'
     * @return string 'pti22_6'
     */
    const VALUE_PTI_22_6 = 'pti22_6';
    /**
     * Constant for value 'tidalRestrictions'
     * @return string 'tidalRestrictions'
     */
    const VALUE_TIDAL_RESTRICTIONS = 'tidalRestrictions';
    /**
     * Constant for value 'pti22_7'
     * @return string 'pti22_7'
     */
    const VALUE_PTI_22_7 = 'pti22_7';
    /**
     * Constant for value 'highTide'
     * @return string 'highTide'
     */
    const VALUE_HIGH_TIDE = 'highTide';
    /**
     * Constant for value 'pti22_8'
     * @return string 'pti22_8'
     */
    const VALUE_PTI_22_8 = 'pti22_8';
    /**
     * Constant for value 'lowTide'
     * @return string 'lowTide'
     */
    const VALUE_LOW_TIDE = 'lowTide';
    /**
     * Constant for value 'pti22_9'
     * @return string 'pti22_9'
     */
    const VALUE_PTI_22_9 = 'pti22_9';
    /**
     * Constant for value 'ice'
     * @return string 'ice'
     */
    const VALUE_ICE = 'ice';
    /**
     * Constant for value 'pti22_9_Alias_1'
     * @return string 'pti22_9_Alias_1'
     */
    const VALUE_PTI_22_9_ALIAS_1 = 'pti22_9_Alias_1';
    /**
     * Constant for value 'slipperiness'
     * @return string 'slipperiness'
     */
    const VALUE_SLIPPERINESS = 'slipperiness';
    /**
     * Constant for value 'pti22_9_Alias_2'
     * @return string 'pti22_9_Alias_2'
     */
    const VALUE_PTI_22_9_ALIAS_2 = 'pti22_9_Alias_2';
    /**
     * Constant for value 'iceDrift'
     * @return string 'iceDrift'
     */
    const VALUE_ICE_DRIFT = 'iceDrift';
    /**
     * Constant for value 'pti22_9_Alias_3'
     * @return string 'pti22_9_Alias_3'
     */
    const VALUE_PTI_22_9_ALIAS_3 = 'pti22_9_Alias_3';
    /**
     * Constant for value 'glazedFrost'
     * @return string 'glazedFrost'
     */
    const VALUE_GLAZED_FROST = 'glazedFrost';
    /**
     * Constant for value 'pti22_10'
     * @return string 'pti22_10'
     */
    const VALUE_PTI_22_10 = 'pti22_10';
    /**
     * Constant for value 'frozen'
     * @return string 'frozen'
     */
    const VALUE_FROZEN = 'frozen';
    /**
     * Constant for value 'pti22_11'
     * @return string 'pti22_11'
     */
    const VALUE_PTI_22_11 = 'pti22_11';
    /**
     * Constant for value 'hail'
     * @return string 'hail'
     */
    const VALUE_HAIL = 'hail';
    /**
     * Constant for value 'pti22_11_Alias_1'
     * @return string 'pti22_11_Alias_1'
     */
    const VALUE_PTI_22_11_ALIAS_1 = 'pti22_11_Alias_1';
    /**
     * Constant for value 'sleet'
     * @return string 'sleet'
     */
    const VALUE_SLEET = 'sleet';
    /**
     * Constant for value 'pti22_12'
     * @return string 'pti22_12'
     */
    const VALUE_PTI_22_12 = 'pti22_12';
    /**
     * Constant for value 'highTemperatures'
     * @return string 'highTemperatures'
     */
    const VALUE_HIGH_TEMPERATURES = 'highTemperatures';
    /**
     * Constant for value 'pti22_13'
     * @return string 'pti22_13'
     */
    const VALUE_PTI_22_13 = 'pti22_13';
    /**
     * Constant for value 'flooding'
     * @return string 'flooding'
     */
    const VALUE_FLOODING = 'flooding';
    /**
     * Constant for value 'pti22_14'
     * @return string 'pti22_14'
     */
    const VALUE_PTI_22_14 = 'pti22_14';
    /**
     * Constant for value 'waterlogged'
     * @return string 'waterlogged'
     */
    const VALUE_WATERLOGGED = 'waterlogged';
    /**
     * Constant for value 'pti22_15'
     * @return string 'pti22_15'
     */
    const VALUE_PTI_22_15 = 'pti22_15';
    /**
     * Constant for value 'lowWaterLevel'
     * @return string 'lowWaterLevel'
     */
    const VALUE_LOW_WATER_LEVEL = 'lowWaterLevel';
    /**
     * Constant for value 'pti22_16'
     * @return string 'pti22_16'
     */
    const VALUE_PTI_22_16 = 'pti22_16';
    /**
     * Constant for value 'highWaterLevel'
     * @return string 'highWaterLevel'
     */
    const VALUE_HIGH_WATER_LEVEL = 'highWaterLevel';
    /**
     * Constant for value 'pti22_17'
     * @return string 'pti22_17'
     */
    const VALUE_PTI_22_17 = 'pti22_17';
    /**
     * Constant for value 'fallenLeaves'
     * @return string 'fallenLeaves'
     */
    const VALUE_FALLEN_LEAVES = 'fallenLeaves';
    /**
     * Constant for value 'pti22_18'
     * @return string 'pti22_18'
     */
    const VALUE_PTI_22_18 = 'pti22_18';
    /**
     * Constant for value 'fallenTree'
     * @return string 'fallenTree'
     */
    const VALUE_FALLEN_TREE = 'fallenTree';
    /**
     * Constant for value 'pti22_19'
     * @return string 'pti22_19'
     */
    const VALUE_PTI_22_19 = 'pti22_19';
    /**
     * Constant for value 'landslide'
     * @return string 'landslide'
     */
    const VALUE_LANDSLIDE = 'landslide';
    /**
     * Constant for value 'pti22_255'
     * @return string 'pti22_255'
     */
    const VALUE_PTI_22_255 = 'pti22_255';
    /**
     * Constant for value 'undefinedEnvironmentalProblem'
     * @return string 'undefinedEnvironmentalProblem'
     */
    const VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM = 'undefinedEnvironmentalProblem';
    /**
     * Constant for value 'pti22_255_Alias_1'
     * @return string 'pti22_255_Alias_1'
     */
    const VALUE_PTI_22_255_ALIAS_1 = 'pti22_255_Alias_1';
    /**
     * Constant for value 'lightningStrike'
     * @return string 'lightningStrike'
     */
    const VALUE_LIGHTNING_STRIKE = 'lightningStrike';
    /**
     * Constant for value 'pti22_255_Alias_2'
     * @return string 'pti22_255_Alias_2'
     */
    const VALUE_PTI_22_255_ALIAS_2 = 'pti22_255_Alias_2';
    /**
     * Constant for value 'sewerOverflow'
     * @return string 'sewerOverflow'
     */
    const VALUE_SEWER_OVERFLOW = 'sewerOverflow';
    /**
     * Constant for value 'pti22_255_Alias_3'
     * @return string 'pti22_255_Alias_3'
     */
    const VALUE_PTI_22_255_ALIAS_3 = 'pti22_255_Alias_3';
    /**
     * Constant for value 'grassFire'
     * @return string 'grassFire'
     */
    const VALUE_GRASS_FIRE = 'grassFire';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_22_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_22_1
     * @uses self::VALUE_FOG
     * @uses self::VALUE_PTI_22_2
     * @uses self::VALUE_ROUGH_SEA
     * @uses self::VALUE_PTI_22_3
     * @uses self::VALUE_HEAVY_SNOW_FALL
     * @uses self::VALUE_PTI_22_3_ALIAS_1
     * @uses self::VALUE_DRIFTING_SNOW
     * @uses self::VALUE_PTI_22_3_ALIAS_2
     * @uses self::VALUE_BLIZZARD_CONDITIONS
     * @uses self::VALUE_PTI_22_4
     * @uses self::VALUE_HEAVY_RAIN
     * @uses self::VALUE_PTI_22_5
     * @uses self::VALUE_STRONG_WINDS
     * @uses self::VALUE_PTI_22_5_ALIAS_1
     * @uses self::VALUE_STORM_CONDITIONS
     * @uses self::VALUE_PTI_22_5_ALIAS_2
     * @uses self::VALUE_STORM_DAMAGE
     * @uses self::VALUE_PTI_22_6
     * @uses self::VALUE_TIDAL_RESTRICTIONS
     * @uses self::VALUE_PTI_22_7
     * @uses self::VALUE_HIGH_TIDE
     * @uses self::VALUE_PTI_22_8
     * @uses self::VALUE_LOW_TIDE
     * @uses self::VALUE_PTI_22_9
     * @uses self::VALUE_ICE
     * @uses self::VALUE_PTI_22_9_ALIAS_1
     * @uses self::VALUE_SLIPPERINESS
     * @uses self::VALUE_PTI_22_9_ALIAS_2
     * @uses self::VALUE_ICE_DRIFT
     * @uses self::VALUE_PTI_22_9_ALIAS_3
     * @uses self::VALUE_GLAZED_FROST
     * @uses self::VALUE_PTI_22_10
     * @uses self::VALUE_FROZEN
     * @uses self::VALUE_PTI_22_11
     * @uses self::VALUE_HAIL
     * @uses self::VALUE_PTI_22_11_ALIAS_1
     * @uses self::VALUE_SLEET
     * @uses self::VALUE_PTI_22_12
     * @uses self::VALUE_HIGH_TEMPERATURES
     * @uses self::VALUE_PTI_22_13
     * @uses self::VALUE_FLOODING
     * @uses self::VALUE_PTI_22_14
     * @uses self::VALUE_WATERLOGGED
     * @uses self::VALUE_PTI_22_15
     * @uses self::VALUE_LOW_WATER_LEVEL
     * @uses self::VALUE_PTI_22_16
     * @uses self::VALUE_HIGH_WATER_LEVEL
     * @uses self::VALUE_PTI_22_17
     * @uses self::VALUE_FALLEN_LEAVES
     * @uses self::VALUE_PTI_22_18
     * @uses self::VALUE_FALLEN_TREE
     * @uses self::VALUE_PTI_22_19
     * @uses self::VALUE_LANDSLIDE
     * @uses self::VALUE_PTI_22_255
     * @uses self::VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM
     * @uses self::VALUE_PTI_22_255_ALIAS_1
     * @uses self::VALUE_LIGHTNING_STRIKE
     * @uses self::VALUE_PTI_22_255_ALIAS_2
     * @uses self::VALUE_SEWER_OVERFLOW
     * @uses self::VALUE_PTI_22_255_ALIAS_3
     * @uses self::VALUE_GRASS_FIRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_22_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_22_1,
            self::VALUE_FOG,
            self::VALUE_PTI_22_2,
            self::VALUE_ROUGH_SEA,
            self::VALUE_PTI_22_3,
            self::VALUE_HEAVY_SNOW_FALL,
            self::VALUE_PTI_22_3_ALIAS_1,
            self::VALUE_DRIFTING_SNOW,
            self::VALUE_PTI_22_3_ALIAS_2,
            self::VALUE_BLIZZARD_CONDITIONS,
            self::VALUE_PTI_22_4,
            self::VALUE_HEAVY_RAIN,
            self::VALUE_PTI_22_5,
            self::VALUE_STRONG_WINDS,
            self::VALUE_PTI_22_5_ALIAS_1,
            self::VALUE_STORM_CONDITIONS,
            self::VALUE_PTI_22_5_ALIAS_2,
            self::VALUE_STORM_DAMAGE,
            self::VALUE_PTI_22_6,
            self::VALUE_TIDAL_RESTRICTIONS,
            self::VALUE_PTI_22_7,
            self::VALUE_HIGH_TIDE,
            self::VALUE_PTI_22_8,
            self::VALUE_LOW_TIDE,
            self::VALUE_PTI_22_9,
            self::VALUE_ICE,
            self::VALUE_PTI_22_9_ALIAS_1,
            self::VALUE_SLIPPERINESS,
            self::VALUE_PTI_22_9_ALIAS_2,
            self::VALUE_ICE_DRIFT,
            self::VALUE_PTI_22_9_ALIAS_3,
            self::VALUE_GLAZED_FROST,
            self::VALUE_PTI_22_10,
            self::VALUE_FROZEN,
            self::VALUE_PTI_22_11,
            self::VALUE_HAIL,
            self::VALUE_PTI_22_11_ALIAS_1,
            self::VALUE_SLEET,
            self::VALUE_PTI_22_12,
            self::VALUE_HIGH_TEMPERATURES,
            self::VALUE_PTI_22_13,
            self::VALUE_FLOODING,
            self::VALUE_PTI_22_14,
            self::VALUE_WATERLOGGED,
            self::VALUE_PTI_22_15,
            self::VALUE_LOW_WATER_LEVEL,
            self::VALUE_PTI_22_16,
            self::VALUE_HIGH_WATER_LEVEL,
            self::VALUE_PTI_22_17,
            self::VALUE_FALLEN_LEAVES,
            self::VALUE_PTI_22_18,
            self::VALUE_FALLEN_TREE,
            self::VALUE_PTI_22_19,
            self::VALUE_LANDSLIDE,
            self::VALUE_PTI_22_255,
            self::VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM,
            self::VALUE_PTI_22_255_ALIAS_1,
            self::VALUE_LIGHTNING_STRIKE,
            self::VALUE_PTI_22_255_ALIAS_2,
            self::VALUE_SEWER_OVERFLOW,
            self::VALUE_PTI_22_255_ALIAS_3,
            self::VALUE_GRASS_FIRE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
