<?php

namespace EnumType;

/**
 * This class stands for DrivingConditionTypeEnum EnumType
 * @subpackage Enumerations
 */
class DrivingConditionTypeEnum
{
    /**
     * Constant for value 'impossible'
     * @return string 'impossible'
     */
    const VALUE_IMPOSSIBLE = 'impossible';
    /**
     * Constant for value 'hazardous'
     * @return string 'hazardous'
     */
    const VALUE_HAZARDOUS = 'hazardous';
    /**
     * Constant for value 'normal'
     * @return string 'normal'
     */
    const VALUE_NORMAL = 'normal';
    /**
     * Constant for value 'passableWithCare'
     * @return string 'passableWithCare'
     */
    const VALUE_PASSABLE_WITH_CARE = 'passableWithCare';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'veryHazardous'
     * @return string 'veryHazardous'
     */
    const VALUE_VERY_HAZARDOUS = 'veryHazardous';
    /**
     * Constant for value 'winterConditions'
     * @return string 'winterConditions'
     */
    const VALUE_WINTER_CONDITIONS = 'winterConditions';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMPOSSIBLE
     * @uses self::VALUE_HAZARDOUS
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PASSABLE_WITH_CARE
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VERY_HAZARDOUS
     * @uses self::VALUE_WINTER_CONDITIONS
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMPOSSIBLE,
            self::VALUE_HAZARDOUS,
            self::VALUE_NORMAL,
            self::VALUE_PASSABLE_WITH_CARE,
            self::VALUE_UNKNOWN,
            self::VALUE_VERY_HAZARDOUS,
            self::VALUE_WINTER_CONDITIONS,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
