<?php

namespace EnumType;

/**
 * This class stands for DisturbanceActivityTypeEnum EnumType
 * @subpackage Enumerations
 */
class DisturbanceActivityTypeEnum
{
    /**
     * Constant for value 'airRaid'
     * @return string 'airRaid'
     */
    const VALUE_AIR_RAID = 'airRaid';
    /**
     * Constant for value 'altercationOfVehicleOccupants'
     * @return string 'altercationOfVehicleOccupants'
     */
    const VALUE_ALTERCATION_OF_VEHICLE_OCCUPANTS = 'altercationOfVehicleOccupants';
    /**
     * Constant for value 'assault'
     * @return string 'assault'
     */
    const VALUE_ASSAULT = 'assault';
    /**
     * Constant for value 'assetDestruction'
     * @return string 'assetDestruction'
     */
    const VALUE_ASSET_DESTRUCTION = 'assetDestruction';
    /**
     * Constant for value 'attack'
     * @return string 'attack'
     */
    const VALUE_ATTACK = 'attack';
    /**
     * Constant for value 'attackOnVehicle'
     * @return string 'attackOnVehicle'
     */
    const VALUE_ATTACK_ON_VEHICLE = 'attackOnVehicle';
    /**
     * Constant for value 'blockadeOrBarrier'
     * @return string 'blockadeOrBarrier'
     */
    const VALUE_BLOCKADE_OR_BARRIER = 'blockadeOrBarrier';
    /**
     * Constant for value 'bombAlert'
     * @return string 'bombAlert'
     */
    const VALUE_BOMB_ALERT = 'bombAlert';
    /**
     * Constant for value 'crowd'
     * @return string 'crowd'
     */
    const VALUE_CROWD = 'crowd';
    /**
     * Constant for value 'demonstration'
     * @return string 'demonstration'
     */
    const VALUE_DEMONSTRATION = 'demonstration';
    /**
     * Constant for value 'evacuation'
     * @return string 'evacuation'
     */
    const VALUE_EVACUATION = 'evacuation';
    /**
     * Constant for value 'filterBlockade'
     * @return string 'filterBlockade'
     */
    const VALUE_FILTER_BLOCKADE = 'filterBlockade';
    /**
     * Constant for value 'goSlowOperation'
     * @return string 'goSlowOperation'
     */
    const VALUE_GO_SLOW_OPERATION = 'goSlowOperation';
    /**
     * Constant for value 'gunfireOnRoadway'
     * @return string 'gunfireOnRoadway'
     */
    const VALUE_GUNFIRE_ON_ROADWAY = 'gunfireOnRoadway';
    /**
     * Constant for value 'illVehicleOccupants'
     * @return string 'illVehicleOccupants'
     */
    const VALUE_ILL_VEHICLE_OCCUPANTS = 'illVehicleOccupants';
    /**
     * Constant for value 'march'
     * @return string 'march'
     */
    const VALUE_MARCH = 'march';
    /**
     * Constant for value 'publicDisturbance'
     * @return string 'publicDisturbance'
     */
    const VALUE_PUBLIC_DISTURBANCE = 'publicDisturbance';
    /**
     * Constant for value 'radioactiveLeakAlert'
     * @return string 'radioactiveLeakAlert'
     */
    const VALUE_RADIOACTIVE_LEAK_ALERT = 'radioactiveLeakAlert';
    /**
     * Constant for value 'riot'
     * @return string 'riot'
     */
    const VALUE_RIOT = 'riot';
    /**
     * Constant for value 'sabotage'
     * @return string 'sabotage'
     */
    const VALUE_SABOTAGE = 'sabotage';
    /**
     * Constant for value 'securityAlert'
     * @return string 'securityAlert'
     */
    const VALUE_SECURITY_ALERT = 'securityAlert';
    /**
     * Constant for value 'securityIncident'
     * @return string 'securityIncident'
     */
    const VALUE_SECURITY_INCIDENT = 'securityIncident';
    /**
     * Constant for value 'sightseersObstructingAccess'
     * @return string 'sightseersObstructingAccess'
     */
    const VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS = 'sightseersObstructingAccess';
    /**
     * Constant for value 'strike'
     * @return string 'strike'
     */
    const VALUE_STRIKE = 'strike';
    /**
     * Constant for value 'terroristIncident'
     * @return string 'terroristIncident'
     */
    const VALUE_TERRORIST_INCIDENT = 'terroristIncident';
    /**
     * Constant for value 'theft'
     * @return string 'theft'
     */
    const VALUE_THEFT = 'theft';
    /**
     * Constant for value 'toxicCloudAlert'
     * @return string 'toxicCloudAlert'
     */
    const VALUE_TOXIC_CLOUD_ALERT = 'toxicCloudAlert';
    /**
     * Constant for value 'unspecifiedAlert'
     * @return string 'unspecifiedAlert'
     */
    const VALUE_UNSPECIFIED_ALERT = 'unspecifiedAlert';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR_RAID
     * @uses self::VALUE_ALTERCATION_OF_VEHICLE_OCCUPANTS
     * @uses self::VALUE_ASSAULT
     * @uses self::VALUE_ASSET_DESTRUCTION
     * @uses self::VALUE_ATTACK
     * @uses self::VALUE_ATTACK_ON_VEHICLE
     * @uses self::VALUE_BLOCKADE_OR_BARRIER
     * @uses self::VALUE_BOMB_ALERT
     * @uses self::VALUE_CROWD
     * @uses self::VALUE_DEMONSTRATION
     * @uses self::VALUE_EVACUATION
     * @uses self::VALUE_FILTER_BLOCKADE
     * @uses self::VALUE_GO_SLOW_OPERATION
     * @uses self::VALUE_GUNFIRE_ON_ROADWAY
     * @uses self::VALUE_ILL_VEHICLE_OCCUPANTS
     * @uses self::VALUE_MARCH
     * @uses self::VALUE_PUBLIC_DISTURBANCE
     * @uses self::VALUE_RADIOACTIVE_LEAK_ALERT
     * @uses self::VALUE_RIOT
     * @uses self::VALUE_SABOTAGE
     * @uses self::VALUE_SECURITY_ALERT
     * @uses self::VALUE_SECURITY_INCIDENT
     * @uses self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS
     * @uses self::VALUE_STRIKE
     * @uses self::VALUE_TERRORIST_INCIDENT
     * @uses self::VALUE_THEFT
     * @uses self::VALUE_TOXIC_CLOUD_ALERT
     * @uses self::VALUE_UNSPECIFIED_ALERT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR_RAID,
            self::VALUE_ALTERCATION_OF_VEHICLE_OCCUPANTS,
            self::VALUE_ASSAULT,
            self::VALUE_ASSET_DESTRUCTION,
            self::VALUE_ATTACK,
            self::VALUE_ATTACK_ON_VEHICLE,
            self::VALUE_BLOCKADE_OR_BARRIER,
            self::VALUE_BOMB_ALERT,
            self::VALUE_CROWD,
            self::VALUE_DEMONSTRATION,
            self::VALUE_EVACUATION,
            self::VALUE_FILTER_BLOCKADE,
            self::VALUE_GO_SLOW_OPERATION,
            self::VALUE_GUNFIRE_ON_ROADWAY,
            self::VALUE_ILL_VEHICLE_OCCUPANTS,
            self::VALUE_MARCH,
            self::VALUE_PUBLIC_DISTURBANCE,
            self::VALUE_RADIOACTIVE_LEAK_ALERT,
            self::VALUE_RIOT,
            self::VALUE_SABOTAGE,
            self::VALUE_SECURITY_ALERT,
            self::VALUE_SECURITY_INCIDENT,
            self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS,
            self::VALUE_STRIKE,
            self::VALUE_TERRORIST_INCIDENT,
            self::VALUE_THEFT,
            self::VALUE_TOXIC_CLOUD_ALERT,
            self::VALUE_UNSPECIFIED_ALERT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
