<?php

namespace EnumType;

/**
 * This class stands for DatexPictogramEnum EnumType
 * @subpackage Enumerations
 */
class DatexPictogramEnum
{
    /**
     * Constant for value 'advisorySpeed'
     * @return string 'advisorySpeed'
     */
    const VALUE_ADVISORY_SPEED = 'advisorySpeed';
    /**
     * Constant for value 'blankVoid'
     * @return string 'blankVoid'
     */
    const VALUE_BLANK_VOID = 'blankVoid';
    /**
     * Constant for value 'chainsOrSnowTyresRecommended'
     * @return string 'chainsOrSnowTyresRecommended'
     */
    const VALUE_CHAINS_OR_SNOW_TYRES_RECOMMENDED = 'chainsOrSnowTyresRecommended';
    /**
     * Constant for value 'crossWind'
     * @return string 'crossWind'
     */
    const VALUE_CROSS_WIND = 'crossWind';
    /**
     * Constant for value 'drivingOfVehiclesLessThanXMetresApartProhibited'
     * @return string 'drivingOfVehiclesLessThanXMetresApartProhibited'
     */
    const VALUE_DRIVING_OF_VEHICLES_LESS_THAN_XMETRES_APART_PROHIBITED = 'drivingOfVehiclesLessThanXMetresApartProhibited';
    /**
     * Constant for value 'endOfAdvisorySpeed'
     * @return string 'endOfAdvisorySpeed'
     */
    const VALUE_END_OF_ADVISORY_SPEED = 'endOfAdvisorySpeed';
    /**
     * Constant for value 'endOfProhibitionOfOvertaking'
     * @return string 'endOfProhibitionOfOvertaking'
     */
    const VALUE_END_OF_PROHIBITION_OF_OVERTAKING = 'endOfProhibitionOfOvertaking';
    /**
     * Constant for value 'endOfProhibitionOfOvertakingForGoodsVehicles'
     * @return string 'endOfProhibitionOfOvertakingForGoodsVehicles'
     */
    const VALUE_END_OF_PROHIBITION_OF_OVERTAKING_FOR_GOODS_VEHICLES = 'endOfProhibitionOfOvertakingForGoodsVehicles';
    /**
     * Constant for value 'endOfSpeedLimit'
     * @return string 'endOfSpeedLimit'
     */
    const VALUE_END_OF_SPEED_LIMIT = 'endOfSpeedLimit';
    /**
     * Constant for value 'exitClosed'
     * @return string 'exitClosed'
     */
    const VALUE_EXIT_CLOSED = 'exitClosed';
    /**
     * Constant for value 'fog'
     * @return string 'fog'
     */
    const VALUE_FOG = 'fog';
    /**
     * Constant for value 'keepASafeDistance'
     * @return string 'keepASafeDistance'
     */
    const VALUE_KEEP_ASAFE_DISTANCE = 'keepASafeDistance';
    /**
     * Constant for value 'maximumSpeedLimit'
     * @return string 'maximumSpeedLimit'
     */
    const VALUE_MAXIMUM_SPEED_LIMIT = 'maximumSpeedLimit';
    /**
     * Constant for value 'noEntry'
     * @return string 'noEntry'
     */
    const VALUE_NO_ENTRY = 'noEntry';
    /**
     * Constant for value 'noEntryForGoodsVehicles'
     * @return string 'noEntryForGoodsVehicles'
     */
    const VALUE_NO_ENTRY_FOR_GOODS_VEHICLES = 'noEntryForGoodsVehicles';
    /**
     * Constant for value 'noEntryForVehiclesExceedingXTonnesLadenMass'
     * @return string 'noEntryForVehiclesExceedingXTonnesLadenMass'
     */
    const VALUE_NO_ENTRY_FOR_VEHICLES_EXCEEDING_XTONNES_LADEN_MASS = 'noEntryForVehiclesExceedingXTonnesLadenMass';
    /**
     * Constant for value 'noEntryForVehiclesHavingAMassExceedingXTonnesOnOneAxle'
     * @return string 'noEntryForVehiclesHavingAMassExceedingXTonnesOnOneAxle'
     */
    const VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AMASS_EXCEEDING_XTONNES_ON_ONE_AXLE = 'noEntryForVehiclesHavingAMassExceedingXTonnesOnOneAxle';
    /**
     * Constant for value 'noEntryForVehiclesHavingAnOverallHeightExceedingXMetres'
     * @return string 'noEntryForVehiclesHavingAnOverallHeightExceedingXMetres'
     */
    const VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_HEIGHT_EXCEEDING_XMETRES = 'noEntryForVehiclesHavingAnOverallHeightExceedingXMetres';
    /**
     * Constant for value 'noEntryForVehiclesHavingAnOverallLengthExceedingXMetres'
     * @return string 'noEntryForVehiclesHavingAnOverallLengthExceedingXMetres'
     */
    const VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_LENGTH_EXCEEDING_XMETRES = 'noEntryForVehiclesHavingAnOverallLengthExceedingXMetres';
    /**
     * Constant for value 'noEntryForVehiclesCarryingDangerousGoods'
     * @return string 'noEntryForVehiclesCarryingDangerousGoods'
     */
    const VALUE_NO_ENTRY_FOR_VEHICLES_CARRYING_DANGEROUS_GOODS = 'noEntryForVehiclesCarryingDangerousGoods';
    /**
     * Constant for value 'otherDanger'
     * @return string 'otherDanger'
     */
    const VALUE_OTHER_DANGER = 'otherDanger';
    /**
     * Constant for value 'overtakingByGoodsVehiclesProhibited'
     * @return string 'overtakingByGoodsVehiclesProhibited'
     */
    const VALUE_OVERTAKING_BY_GOODS_VEHICLES_PROHIBITED = 'overtakingByGoodsVehiclesProhibited';
    /**
     * Constant for value 'overtakingProhibited'
     * @return string 'overtakingProhibited'
     */
    const VALUE_OVERTAKING_PROHIBITED = 'overtakingProhibited';
    /**
     * Constant for value 'roadClosedAhead'
     * @return string 'roadClosedAhead'
     */
    const VALUE_ROAD_CLOSED_AHEAD = 'roadClosedAhead';
    /**
     * Constant for value 'roadworks'
     * @return string 'roadworks'
     */
    const VALUE_ROADWORKS = 'roadworks';
    /**
     * Constant for value 'slipperyRoad'
     * @return string 'slipperyRoad'
     */
    const VALUE_SLIPPERY_ROAD = 'slipperyRoad';
    /**
     * Constant for value 'snow'
     * @return string 'snow'
     */
    const VALUE_SNOW = 'snow';
    /**
     * Constant for value 'snowTyresCompulsory'
     * @return string 'snowTyresCompulsory'
     */
    const VALUE_SNOW_TYRES_COMPULSORY = 'snowTyresCompulsory';
    /**
     * Constant for value 'trafficCongestion'
     * @return string 'trafficCongestion'
     */
    const VALUE_TRAFFIC_CONGESTION = 'trafficCongestion';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADVISORY_SPEED
     * @uses self::VALUE_BLANK_VOID
     * @uses self::VALUE_CHAINS_OR_SNOW_TYRES_RECOMMENDED
     * @uses self::VALUE_CROSS_WIND
     * @uses self::VALUE_DRIVING_OF_VEHICLES_LESS_THAN_XMETRES_APART_PROHIBITED
     * @uses self::VALUE_END_OF_ADVISORY_SPEED
     * @uses self::VALUE_END_OF_PROHIBITION_OF_OVERTAKING
     * @uses self::VALUE_END_OF_PROHIBITION_OF_OVERTAKING_FOR_GOODS_VEHICLES
     * @uses self::VALUE_END_OF_SPEED_LIMIT
     * @uses self::VALUE_EXIT_CLOSED
     * @uses self::VALUE_FOG
     * @uses self::VALUE_KEEP_ASAFE_DISTANCE
     * @uses self::VALUE_MAXIMUM_SPEED_LIMIT
     * @uses self::VALUE_NO_ENTRY
     * @uses self::VALUE_NO_ENTRY_FOR_GOODS_VEHICLES
     * @uses self::VALUE_NO_ENTRY_FOR_VEHICLES_EXCEEDING_XTONNES_LADEN_MASS
     * @uses self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AMASS_EXCEEDING_XTONNES_ON_ONE_AXLE
     * @uses self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_HEIGHT_EXCEEDING_XMETRES
     * @uses self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_LENGTH_EXCEEDING_XMETRES
     * @uses self::VALUE_NO_ENTRY_FOR_VEHICLES_CARRYING_DANGEROUS_GOODS
     * @uses self::VALUE_OTHER_DANGER
     * @uses self::VALUE_OVERTAKING_BY_GOODS_VEHICLES_PROHIBITED
     * @uses self::VALUE_OVERTAKING_PROHIBITED
     * @uses self::VALUE_ROAD_CLOSED_AHEAD
     * @uses self::VALUE_ROADWORKS
     * @uses self::VALUE_SLIPPERY_ROAD
     * @uses self::VALUE_SNOW
     * @uses self::VALUE_SNOW_TYRES_COMPULSORY
     * @uses self::VALUE_TRAFFIC_CONGESTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADVISORY_SPEED,
            self::VALUE_BLANK_VOID,
            self::VALUE_CHAINS_OR_SNOW_TYRES_RECOMMENDED,
            self::VALUE_CROSS_WIND,
            self::VALUE_DRIVING_OF_VEHICLES_LESS_THAN_XMETRES_APART_PROHIBITED,
            self::VALUE_END_OF_ADVISORY_SPEED,
            self::VALUE_END_OF_PROHIBITION_OF_OVERTAKING,
            self::VALUE_END_OF_PROHIBITION_OF_OVERTAKING_FOR_GOODS_VEHICLES,
            self::VALUE_END_OF_SPEED_LIMIT,
            self::VALUE_EXIT_CLOSED,
            self::VALUE_FOG,
            self::VALUE_KEEP_ASAFE_DISTANCE,
            self::VALUE_MAXIMUM_SPEED_LIMIT,
            self::VALUE_NO_ENTRY,
            self::VALUE_NO_ENTRY_FOR_GOODS_VEHICLES,
            self::VALUE_NO_ENTRY_FOR_VEHICLES_EXCEEDING_XTONNES_LADEN_MASS,
            self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AMASS_EXCEEDING_XTONNES_ON_ONE_AXLE,
            self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_HEIGHT_EXCEEDING_XMETRES,
            self::VALUE_NO_ENTRY_FOR_VEHICLES_HAVING_AN_OVERALL_LENGTH_EXCEEDING_XMETRES,
            self::VALUE_NO_ENTRY_FOR_VEHICLES_CARRYING_DANGEROUS_GOODS,
            self::VALUE_OTHER_DANGER,
            self::VALUE_OVERTAKING_BY_GOODS_VEHICLES_PROHIBITED,
            self::VALUE_OVERTAKING_PROHIBITED,
            self::VALUE_ROAD_CLOSED_AHEAD,
            self::VALUE_ROADWORKS,
            self::VALUE_SLIPPERY_ROAD,
            self::VALUE_SNOW,
            self::VALUE_SNOW_TYRES_COMPULSORY,
            self::VALUE_TRAFFIC_CONGESTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
