<?php

namespace EnumType;

/**
 * This class stands for ConnectionMonitoringDetailEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Detail Levels for Connection Monitoring Request.
 * @subpackage Enumerations
 */
class ConnectionMonitoringDetailEnumeration
{
    /**
     * Constant for value 'minimum'
     * @return string 'minimum'
     */
    const VALUE_MINIMUM = 'minimum';
    /**
     * Constant for value 'basic'
     * @return string 'basic'
     */
    const VALUE_BASIC = 'basic';
    /**
     * Constant for value 'normal'
     * @return string 'normal'
     */
    const VALUE_NORMAL = 'normal';
    /**
     * Constant for value 'full'
     * @return string 'full'
     */
    const VALUE_FULL = 'full';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MINIMUM
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_FULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MINIMUM,
            self::VALUE_BASIC,
            self::VALUE_NORMAL,
            self::VALUE_FULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
