<?php

namespace EnumType;

/**
 * This class stands for ComputationMethodEnum EnumType
 * @subpackage Enumerations
 */
class ComputationMethodEnum
{
    /**
     * Constant for value 'arithmeticAverageOfSamplesBasedOnAFixedNumberOfSamples'
     * @return string 'arithmeticAverageOfSamplesBasedOnAFixedNumberOfSamples'
     */
    const VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_BASED_ON_AFIXED_NUMBER_OF_SAMPLES = 'arithmeticAverageOfSamplesBasedOnAFixedNumberOfSamples';
    /**
     * Constant for value 'arithmeticAverageOfSamplesInATimePeriod'
     * @return string 'arithmeticAverageOfSamplesInATimePeriod'
     */
    const VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD = 'arithmeticAverageOfSamplesInATimePeriod';
    /**
     * Constant for value 'harmonicAverageOfSamplesInATimePeriod'
     * @return string 'harmonicAverageOfSamplesInATimePeriod'
     */
    const VALUE_HARMONIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD = 'harmonicAverageOfSamplesInATimePeriod';
    /**
     * Constant for value 'medianOfSamplesInATimePeriod'
     * @return string 'medianOfSamplesInATimePeriod'
     */
    const VALUE_MEDIAN_OF_SAMPLES_IN_ATIME_PERIOD = 'medianOfSamplesInATimePeriod';
    /**
     * Constant for value 'movingAverageOfSamples'
     * @return string 'movingAverageOfSamples'
     */
    const VALUE_MOVING_AVERAGE_OF_SAMPLES = 'movingAverageOfSamples';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_BASED_ON_AFIXED_NUMBER_OF_SAMPLES
     * @uses self::VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD
     * @uses self::VALUE_HARMONIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD
     * @uses self::VALUE_MEDIAN_OF_SAMPLES_IN_ATIME_PERIOD
     * @uses self::VALUE_MOVING_AVERAGE_OF_SAMPLES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_BASED_ON_AFIXED_NUMBER_OF_SAMPLES,
            self::VALUE_ARITHMETIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD,
            self::VALUE_HARMONIC_AVERAGE_OF_SAMPLES_IN_ATIME_PERIOD,
            self::VALUE_MEDIAN_OF_SAMPLES_IN_ATIME_PERIOD,
            self::VALUE_MOVING_AVERAGE_OF_SAMPLES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
