<?php

namespace EnumType;

/**
 * This class stands for CompressionMethodEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of compression usage.
 * @subpackage Enumerations
 */
class CompressionMethodEnumeration
{
    /**
     * Constant for value 'gzip'
     * @return string 'gzip'
     */
    const VALUE_GZIP = 'gzip';
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GZIP
     * @uses self::VALUE_NONE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GZIP,
            self::VALUE_NONE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
