<?php

namespace EnumType;

/**
 * This class stands for ComparisonOperatorEnum EnumType
 * @subpackage Enumerations
 */
class ComparisonOperatorEnum
{
    /**
     * Constant for value 'equalTo'
     * @return string 'equalTo'
     */
    const VALUE_EQUAL_TO = 'equalTo';
    /**
     * Constant for value 'greaterThan'
     * @return string 'greaterThan'
     */
    const VALUE_GREATER_THAN = 'greaterThan';
    /**
     * Constant for value 'greatherThanOrEqualTo'
     * @return string 'greatherThanOrEqualTo'
     */
    const VALUE_GREATHER_THAN_OR_EQUAL_TO = 'greatherThanOrEqualTo';
    /**
     * Constant for value 'lessThan'
     * @return string 'lessThan'
     */
    const VALUE_LESS_THAN = 'lessThan';
    /**
     * Constant for value 'lessThanOrEqualTo'
     * @return string 'lessThanOrEqualTo'
     */
    const VALUE_LESS_THAN_OR_EQUAL_TO = 'lessThanOrEqualTo';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUAL_TO
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_GREATHER_THAN_OR_EQUAL_TO
     * @uses self::VALUE_LESS_THAN
     * @uses self::VALUE_LESS_THAN_OR_EQUAL_TO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUAL_TO,
            self::VALUE_GREATER_THAN,
            self::VALUE_GREATHER_THAN_OR_EQUAL_TO,
            self::VALUE_LESS_THAN,
            self::VALUE_LESS_THAN_OR_EQUAL_TO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
