<?php

namespace EnumType;

/**
 * This class stands for CheckPointProcessEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for a CHECK CONSTRAINT.
 * @subpackage Enumerations
 */
class CheckPointProcessEnumeration
{
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'ticketPurchase'
     * @return string 'ticketPurchase'
     */
    const VALUE_TICKET_PURCHASE = 'ticketPurchase';
    /**
     * Constant for value 'ticketCollection'
     * @return string 'ticketCollection'
     */
    const VALUE_TICKET_COLLECTION = 'ticketCollection';
    /**
     * Constant for value 'ticketValidation'
     * @return string 'ticketValidation'
     */
    const VALUE_TICKET_VALIDATION = 'ticketValidation';
    /**
     * Constant for value 'baggageCheckIn'
     * @return string 'baggageCheckIn'
     */
    const VALUE_BAGGAGE_CHECK_IN = 'baggageCheckIn';
    /**
     * Constant for value 'oversizeBaggageCheckIn'
     * @return string 'oversizeBaggageCheckIn'
     */
    const VALUE_OVERSIZE_BAGGAGE_CHECK_IN = 'oversizeBaggageCheckIn';
    /**
     * Constant for value 'oversizeBaggageReclaim'
     * @return string 'oversizeBaggageReclaim'
     */
    const VALUE_OVERSIZE_BAGGAGE_RECLAIM = 'oversizeBaggageReclaim';
    /**
     * Constant for value 'baggageReclaim'
     * @return string 'baggageReclaim'
     */
    const VALUE_BAGGAGE_RECLAIM = 'baggageReclaim';
    /**
     * Constant for value 'leftLuggageDeposit'
     * @return string 'leftLuggageDeposit'
     */
    const VALUE_LEFT_LUGGAGE_DEPOSIT = 'leftLuggageDeposit';
    /**
     * Constant for value 'leftLuggageReclaim'
     * @return string 'leftLuggageReclaim'
     */
    const VALUE_LEFT_LUGGAGE_RECLAIM = 'leftLuggageReclaim';
    /**
     * Constant for value 'firstclassCheckin'
     * @return string 'firstclassCheckin'
     */
    const VALUE_FIRSTCLASS_CHECKIN = 'firstclassCheckin';
    /**
     * Constant for value 'specialNeedsCheckin'
     * @return string 'specialNeedsCheckin'
     */
    const VALUE_SPECIAL_NEEDS_CHECKIN = 'specialNeedsCheckin';
    /**
     * Constant for value 'baggageSecurityCheck'
     * @return string 'baggageSecurityCheck'
     */
    const VALUE_BAGGAGE_SECURITY_CHECK = 'baggageSecurityCheck';
    /**
     * Constant for value 'securityCheck'
     * @return string 'securityCheck'
     */
    const VALUE_SECURITY_CHECK = 'securityCheck';
    /**
     * Constant for value 'outgoingPassportControl'
     * @return string 'outgoingPassportControl'
     */
    const VALUE_OUTGOING_PASSPORT_CONTROL = 'outgoingPassportControl';
    /**
     * Constant for value 'incomingPassportControl'
     * @return string 'incomingPassportControl'
     */
    const VALUE_INCOMING_PASSPORT_CONTROL = 'incomingPassportControl';
    /**
     * Constant for value 'fasttrackDepartures'
     * @return string 'fasttrackDepartures'
     */
    const VALUE_FASTTRACK_DEPARTURES = 'fasttrackDepartures';
    /**
     * Constant for value 'fasttrackArrivals'
     * @return string 'fasttrackArrivals'
     */
    const VALUE_FASTTRACK_ARRIVALS = 'fasttrackArrivals';
    /**
     * Constant for value 'incomingDutyFree'
     * @return string 'incomingDutyFree'
     */
    const VALUE_INCOMING_DUTY_FREE = 'incomingDutyFree';
    /**
     * Constant for value 'outgoingDutyFree'
     * @return string 'outgoingDutyFree'
     */
    const VALUE_OUTGOING_DUTY_FREE = 'outgoingDutyFree';
    /**
     * Constant for value 'taxRefunds'
     * @return string 'taxRefunds'
     */
    const VALUE_TAX_REFUNDS = 'taxRefunds';
    /**
     * Constant for value 'outgoingCustoms'
     * @return string 'outgoingCustoms'
     */
    const VALUE_OUTGOING_CUSTOMS = 'outgoingCustoms';
    /**
     * Constant for value 'incomingCustoms'
     * @return string 'incomingCustoms'
     */
    const VALUE_INCOMING_CUSTOMS = 'incomingCustoms';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_TICKET_PURCHASE
     * @uses self::VALUE_TICKET_COLLECTION
     * @uses self::VALUE_TICKET_VALIDATION
     * @uses self::VALUE_BAGGAGE_CHECK_IN
     * @uses self::VALUE_OVERSIZE_BAGGAGE_CHECK_IN
     * @uses self::VALUE_OVERSIZE_BAGGAGE_RECLAIM
     * @uses self::VALUE_BAGGAGE_RECLAIM
     * @uses self::VALUE_LEFT_LUGGAGE_DEPOSIT
     * @uses self::VALUE_LEFT_LUGGAGE_RECLAIM
     * @uses self::VALUE_FIRSTCLASS_CHECKIN
     * @uses self::VALUE_SPECIAL_NEEDS_CHECKIN
     * @uses self::VALUE_BAGGAGE_SECURITY_CHECK
     * @uses self::VALUE_SECURITY_CHECK
     * @uses self::VALUE_OUTGOING_PASSPORT_CONTROL
     * @uses self::VALUE_INCOMING_PASSPORT_CONTROL
     * @uses self::VALUE_FASTTRACK_DEPARTURES
     * @uses self::VALUE_FASTTRACK_ARRIVALS
     * @uses self::VALUE_INCOMING_DUTY_FREE
     * @uses self::VALUE_OUTGOING_DUTY_FREE
     * @uses self::VALUE_TAX_REFUNDS
     * @uses self::VALUE_OUTGOING_CUSTOMS
     * @uses self::VALUE_INCOMING_CUSTOMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_UNKNOWN,
            self::VALUE_TICKET_PURCHASE,
            self::VALUE_TICKET_COLLECTION,
            self::VALUE_TICKET_VALIDATION,
            self::VALUE_BAGGAGE_CHECK_IN,
            self::VALUE_OVERSIZE_BAGGAGE_CHECK_IN,
            self::VALUE_OVERSIZE_BAGGAGE_RECLAIM,
            self::VALUE_BAGGAGE_RECLAIM,
            self::VALUE_LEFT_LUGGAGE_DEPOSIT,
            self::VALUE_LEFT_LUGGAGE_RECLAIM,
            self::VALUE_FIRSTCLASS_CHECKIN,
            self::VALUE_SPECIAL_NEEDS_CHECKIN,
            self::VALUE_BAGGAGE_SECURITY_CHECK,
            self::VALUE_SECURITY_CHECK,
            self::VALUE_OUTGOING_PASSPORT_CONTROL,
            self::VALUE_INCOMING_PASSPORT_CONTROL,
            self::VALUE_FASTTRACK_DEPARTURES,
            self::VALUE_FASTTRACK_ARRIVALS,
            self::VALUE_INCOMING_DUTY_FREE,
            self::VALUE_OUTGOING_DUTY_FREE,
            self::VALUE_TAX_REFUNDS,
            self::VALUE_OUTGOING_CUSTOMS,
            self::VALUE_INCOMING_CUSTOMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
