<?php

namespace EnumType;

/**
 * This class stands for BoardingActivityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed types activity for Boarding and Alighting.
 * @subpackage Enumerations
 */
class BoardingActivityEnumeration
{
    /**
     * Constant for value 'boardingAndAlighting'
     * @return string 'boardingAndAlighting'
     */
    const VALUE_BOARDING_AND_ALIGHTING = 'boardingAndAlighting';
    /**
     * Constant for value 'noBoarding'
     * @return string 'noBoarding'
     */
    const VALUE_NO_BOARDING = 'noBoarding';
    /**
     * Constant for value 'noAlighting'
     * @return string 'noAlighting'
     */
    const VALUE_NO_ALIGHTING = 'noAlighting';
    /**
     * Constant for value 'passThru'
     * @return string 'passThru'
     */
    const VALUE_PASS_THRU = 'passThru';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOARDING_AND_ALIGHTING
     * @uses self::VALUE_NO_BOARDING
     * @uses self::VALUE_NO_ALIGHTING
     * @uses self::VALUE_PASS_THRU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOARDING_AND_ALIGHTING,
            self::VALUE_NO_BOARDING,
            self::VALUE_NO_ALIGHTING,
            self::VALUE_PASS_THRU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
