<?php

namespace EnumType;

/**
 * This class stands for ArrivalBoardingActivityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed types activity for Alighting.
 * @subpackage Enumerations
 */
class ArrivalBoardingActivityEnumeration
{
    /**
     * Constant for value 'alighting'
     * @return string 'alighting'
     */
    const VALUE_ALIGHTING = 'alighting';
    /**
     * Constant for value 'noAlighting'
     * @return string 'noAlighting'
     */
    const VALUE_NO_ALIGHTING = 'noAlighting';
    /**
     * Constant for value 'passThru'
     * @return string 'passThru'
     */
    const VALUE_PASS_THRU = 'passThru';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALIGHTING
     * @uses self::VALUE_NO_ALIGHTING
     * @uses self::VALUE_PASS_THRU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALIGHTING,
            self::VALUE_NO_ALIGHTING,
            self::VALUE_PASS_THRU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
