<?php

namespace EnumType;

/**
 * This class stands for AlertCDirectionEnum EnumType
 * @subpackage Enumerations
 */
class AlertCDirectionEnum
{
    /**
     * Constant for value 'both'
     * @return string 'both'
     */
    const VALUE_BOTH = 'both';
    /**
     * Constant for value 'negative'
     * @return string 'negative'
     */
    const VALUE_NEGATIVE = 'negative';
    /**
     * Constant for value 'positive'
     * @return string 'positive'
     */
    const VALUE_POSITIVE = 'positive';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOTH
     * @uses self::VALUE_NEGATIVE
     * @uses self::VALUE_POSITIVE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOTH,
            self::VALUE_NEGATIVE,
            self::VALUE_POSITIVE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
